/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.ConnectPeerConfiguration;
import software.amazon.awssdk.services.networkmanager.model.ConnectPeerError;
import software.amazon.awssdk.services.networkmanager.model.ConnectPeerErrorListCopier;
import software.amazon.awssdk.services.networkmanager.model.ConnectPeerState;
import software.amazon.awssdk.services.networkmanager.model.Tag;
import software.amazon.awssdk.services.networkmanager.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectPeer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectPeer> {
    private static final SdkField<String> CORE_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CoreNetworkId").getter(ConnectPeer.getter(ConnectPeer::coreNetworkId)).setter(ConnectPeer.setter(Builder::coreNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkId").build()}).build();
    private static final SdkField<String> CONNECT_ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectAttachmentId").getter(ConnectPeer.getter(ConnectPeer::connectAttachmentId)).setter(ConnectPeer.setter(Builder::connectAttachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectAttachmentId").build()}).build();
    private static final SdkField<String> CONNECT_PEER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectPeerId").getter(ConnectPeer.getter(ConnectPeer::connectPeerId)).setter(ConnectPeer.setter(Builder::connectPeerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectPeerId").build()}).build();
    private static final SdkField<String> EDGE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EdgeLocation").getter(ConnectPeer.getter(ConnectPeer::edgeLocation)).setter(ConnectPeer.setter(Builder::edgeLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeLocation").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ConnectPeer.getter(ConnectPeer::stateAsString)).setter(ConnectPeer.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(ConnectPeer.getter(ConnectPeer::createdAt)).setter(ConnectPeer.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<ConnectPeerConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Configuration").getter(ConnectPeer.getter(ConnectPeer::configuration)).setter(ConnectPeer.setter(Builder::configuration)).constructor(ConnectPeerConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ConnectPeer.getter(ConnectPeer::tags)).setter(ConnectPeer.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SUBNET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetArn").getter(ConnectPeer.getter(ConnectPeer::subnetArn)).setter(ConnectPeer.setter(Builder::subnetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetArn").build()}).build();
    private static final SdkField<List<ConnectPeerError>> LAST_MODIFICATION_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LastModificationErrors").getter(ConnectPeer.getter(ConnectPeer::lastModificationErrors)).setter(ConnectPeer.setter(Builder::lastModificationErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationErrors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConnectPeerError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_NETWORK_ID_FIELD, CONNECT_ATTACHMENT_ID_FIELD, CONNECT_PEER_ID_FIELD, EDGE_LOCATION_FIELD, STATE_FIELD, CREATED_AT_FIELD, CONFIGURATION_FIELD, TAGS_FIELD, SUBNET_ARN_FIELD, LAST_MODIFICATION_ERRORS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String coreNetworkId;
    private final String connectAttachmentId;
    private final String connectPeerId;
    private final String edgeLocation;
    private final String state;
    private final Instant createdAt;
    private final ConnectPeerConfiguration configuration;
    private final List<Tag> tags;
    private final String subnetArn;
    private final List<ConnectPeerError> lastModificationErrors;

    private ConnectPeer(BuilderImpl builder) {
        this.coreNetworkId = builder.coreNetworkId;
        this.connectAttachmentId = builder.connectAttachmentId;
        this.connectPeerId = builder.connectPeerId;
        this.edgeLocation = builder.edgeLocation;
        this.state = builder.state;
        this.createdAt = builder.createdAt;
        this.configuration = builder.configuration;
        this.tags = builder.tags;
        this.subnetArn = builder.subnetArn;
        this.lastModificationErrors = builder.lastModificationErrors;
    }

    public final String coreNetworkId() {
        return this.coreNetworkId;
    }

    public final String connectAttachmentId() {
        return this.connectAttachmentId;
    }

    public final String connectPeerId() {
        return this.connectPeerId;
    }

    public final String edgeLocation() {
        return this.edgeLocation;
    }

    public final ConnectPeerState state() {
        return ConnectPeerState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final ConnectPeerConfiguration configuration() {
        return this.configuration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String subnetArn() {
        return this.subnetArn;
    }

    public final boolean hasLastModificationErrors() {
        return this.lastModificationErrors != null && !(this.lastModificationErrors instanceof SdkAutoConstructList);
    }

    public final List<ConnectPeerError> lastModificationErrors() {
        return this.lastModificationErrors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.coreNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectPeerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.edgeLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLastModificationErrors() ? this.lastModificationErrors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectPeer)) {
            return false;
        }
        ConnectPeer other = (ConnectPeer)obj;
        return Objects.equals(this.coreNetworkId(), other.coreNetworkId()) && Objects.equals(this.connectAttachmentId(), other.connectAttachmentId()) && Objects.equals(this.connectPeerId(), other.connectPeerId()) && Objects.equals(this.edgeLocation(), other.edgeLocation()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.configuration(), other.configuration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.subnetArn(), other.subnetArn()) && this.hasLastModificationErrors() == other.hasLastModificationErrors() && Objects.equals(this.lastModificationErrors(), other.lastModificationErrors());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectPeer").add("CoreNetworkId", (Object)this.coreNetworkId()).add("ConnectAttachmentId", (Object)this.connectAttachmentId()).add("ConnectPeerId", (Object)this.connectPeerId()).add("EdgeLocation", (Object)this.edgeLocation()).add("State", (Object)this.stateAsString()).add("CreatedAt", (Object)this.createdAt()).add("Configuration", (Object)this.configuration()).add("Tags", this.hasTags() ? this.tags() : null).add("SubnetArn", (Object)this.subnetArn()).add("LastModificationErrors", this.hasLastModificationErrors() ? this.lastModificationErrors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CoreNetworkId": {
                return Optional.ofNullable(clazz.cast(this.coreNetworkId()));
            }
            case "ConnectAttachmentId": {
                return Optional.ofNullable(clazz.cast(this.connectAttachmentId()));
            }
            case "ConnectPeerId": {
                return Optional.ofNullable(clazz.cast(this.connectPeerId()));
            }
            case "EdgeLocation": {
                return Optional.ofNullable(clazz.cast(this.edgeLocation()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "SubnetArn": {
                return Optional.ofNullable(clazz.cast(this.subnetArn()));
            }
            case "LastModificationErrors": {
                return Optional.ofNullable(clazz.cast(this.lastModificationErrors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectPeer, T> g) {
        return obj -> g.apply((ConnectPeer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String coreNetworkId;
        private String connectAttachmentId;
        private String connectPeerId;
        private String edgeLocation;
        private String state;
        private Instant createdAt;
        private ConnectPeerConfiguration configuration;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String subnetArn;
        private List<ConnectPeerError> lastModificationErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectPeer model) {
            this.coreNetworkId(model.coreNetworkId);
            this.connectAttachmentId(model.connectAttachmentId);
            this.connectPeerId(model.connectPeerId);
            this.edgeLocation(model.edgeLocation);
            this.state(model.state);
            this.createdAt(model.createdAt);
            this.configuration(model.configuration);
            this.tags(model.tags);
            this.subnetArn(model.subnetArn);
            this.lastModificationErrors(model.lastModificationErrors);
        }

        public final String getCoreNetworkId() {
            return this.coreNetworkId;
        }

        public final void setCoreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
        }

        @Override
        public final Builder coreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        public final String getConnectAttachmentId() {
            return this.connectAttachmentId;
        }

        public final void setConnectAttachmentId(String connectAttachmentId) {
            this.connectAttachmentId = connectAttachmentId;
        }

        @Override
        public final Builder connectAttachmentId(String connectAttachmentId) {
            this.connectAttachmentId = connectAttachmentId;
            return this;
        }

        public final String getConnectPeerId() {
            return this.connectPeerId;
        }

        public final void setConnectPeerId(String connectPeerId) {
            this.connectPeerId = connectPeerId;
        }

        @Override
        public final Builder connectPeerId(String connectPeerId) {
            this.connectPeerId = connectPeerId;
            return this;
        }

        public final String getEdgeLocation() {
            return this.edgeLocation;
        }

        public final void setEdgeLocation(String edgeLocation) {
            this.edgeLocation = edgeLocation;
        }

        @Override
        public final Builder edgeLocation(String edgeLocation) {
            this.edgeLocation = edgeLocation;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ConnectPeerState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final ConnectPeerConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(ConnectPeerConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(ConnectPeerConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSubnetArn() {
            return this.subnetArn;
        }

        public final void setSubnetArn(String subnetArn) {
            this.subnetArn = subnetArn;
        }

        @Override
        public final Builder subnetArn(String subnetArn) {
            this.subnetArn = subnetArn;
            return this;
        }

        public final List<ConnectPeerError.Builder> getLastModificationErrors() {
            List<ConnectPeerError.Builder> result = ConnectPeerErrorListCopier.copyToBuilder(this.lastModificationErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLastModificationErrors(Collection<ConnectPeerError.BuilderImpl> lastModificationErrors) {
            this.lastModificationErrors = ConnectPeerErrorListCopier.copyFromBuilder(lastModificationErrors);
        }

        @Override
        public final Builder lastModificationErrors(Collection<ConnectPeerError> lastModificationErrors) {
            this.lastModificationErrors = ConnectPeerErrorListCopier.copy(lastModificationErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastModificationErrors(ConnectPeerError ... lastModificationErrors) {
            this.lastModificationErrors(Arrays.asList(lastModificationErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastModificationErrors(Consumer<ConnectPeerError.Builder> ... lastModificationErrors) {
            this.lastModificationErrors(Stream.of(lastModificationErrors).map(c -> (ConnectPeerError)((ConnectPeerError.Builder)ConnectPeerError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ConnectPeer build() {
            return new ConnectPeer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectPeer> {
        public Builder coreNetworkId(String var1);

        public Builder connectAttachmentId(String var1);

        public Builder connectPeerId(String var1);

        public Builder edgeLocation(String var1);

        public Builder state(String var1);

        public Builder state(ConnectPeerState var1);

        public Builder createdAt(Instant var1);

        public Builder configuration(ConnectPeerConfiguration var1);

        default public Builder configuration(Consumer<ConnectPeerConfiguration.Builder> configuration) {
            return this.configuration((ConnectPeerConfiguration)((ConnectPeerConfiguration.Builder)ConnectPeerConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder subnetArn(String var1);

        public Builder lastModificationErrors(Collection<ConnectPeerError> var1);

        public Builder lastModificationErrors(ConnectPeerError ... var1);

        public Builder lastModificationErrors(Consumer<ConnectPeerError.Builder> ... var1);
    }
}

