/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.networkmanager.model.NetworkResourceMetadataMapCopier;
import software.amazon.awssdk.services.networkmanager.model.Tag;
import software.amazon.awssdk.services.networkmanager.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkResource> {
    private static final SdkField<String> REGISTERED_GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegisteredGatewayArn").getter(NetworkResource.getter(NetworkResource::registeredGatewayArn)).setter(NetworkResource.setter(Builder::registeredGatewayArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegisteredGatewayArn").build()}).build();
    private static final SdkField<String> CORE_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CoreNetworkId").getter(NetworkResource.getter(NetworkResource::coreNetworkId)).setter(NetworkResource.setter(Builder::coreNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkId").build()}).build();
    private static final SdkField<String> AWS_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsRegion").getter(NetworkResource.getter(NetworkResource::awsRegion)).setter(NetworkResource.setter(Builder::awsRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegion").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(NetworkResource.getter(NetworkResource::accountId)).setter(NetworkResource.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(NetworkResource.getter(NetworkResource::resourceType)).setter(NetworkResource.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(NetworkResource.getter(NetworkResource::resourceId)).setter(NetworkResource.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(NetworkResource.getter(NetworkResource::resourceArn)).setter(NetworkResource.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<String> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Definition").getter(NetworkResource.getter(NetworkResource::definition)).setter(NetworkResource.setter(Builder::definition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build()}).build();
    private static final SdkField<Instant> DEFINITION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DefinitionTimestamp").getter(NetworkResource.getter(NetworkResource::definitionTimestamp)).setter(NetworkResource.setter(Builder::definitionTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefinitionTimestamp").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(NetworkResource.getter(NetworkResource::tags)).setter(NetworkResource.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Metadata").getter(NetworkResource.getter(NetworkResource::metadata)).setter(NetworkResource.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTERED_GATEWAY_ARN_FIELD, CORE_NETWORK_ID_FIELD, AWS_REGION_FIELD, ACCOUNT_ID_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD, RESOURCE_ARN_FIELD, DEFINITION_FIELD, DEFINITION_TIMESTAMP_FIELD, TAGS_FIELD, METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RegisteredGatewayArn", REGISTERED_GATEWAY_ARN_FIELD);
            this.put("CoreNetworkId", CORE_NETWORK_ID_FIELD);
            this.put("AwsRegion", AWS_REGION_FIELD);
            this.put("AccountId", ACCOUNT_ID_FIELD);
            this.put("ResourceType", RESOURCE_TYPE_FIELD);
            this.put("ResourceId", RESOURCE_ID_FIELD);
            this.put("ResourceArn", RESOURCE_ARN_FIELD);
            this.put("Definition", DEFINITION_FIELD);
            this.put("DefinitionTimestamp", DEFINITION_TIMESTAMP_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("Metadata", METADATA_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String registeredGatewayArn;
    private final String coreNetworkId;
    private final String awsRegion;
    private final String accountId;
    private final String resourceType;
    private final String resourceId;
    private final String resourceArn;
    private final String definition;
    private final Instant definitionTimestamp;
    private final List<Tag> tags;
    private final Map<String, String> metadata;

    private NetworkResource(BuilderImpl builder) {
        this.registeredGatewayArn = builder.registeredGatewayArn;
        this.coreNetworkId = builder.coreNetworkId;
        this.awsRegion = builder.awsRegion;
        this.accountId = builder.accountId;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.resourceArn = builder.resourceArn;
        this.definition = builder.definition;
        this.definitionTimestamp = builder.definitionTimestamp;
        this.tags = builder.tags;
        this.metadata = builder.metadata;
    }

    public final String registeredGatewayArn() {
        return this.registeredGatewayArn;
    }

    public final String coreNetworkId() {
        return this.coreNetworkId;
    }

    public final String awsRegion() {
        return this.awsRegion;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String definition() {
        return this.definition;
    }

    public final Instant definitionTimestamp() {
        return this.definitionTimestamp;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final boolean hasMetadata() {
        return this.metadata != null && !(this.metadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> metadata() {
        return this.metadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.registeredGatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.coreNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.definitionTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadata() ? this.metadata() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkResource)) {
            return false;
        }
        NetworkResource other = (NetworkResource)obj;
        return Objects.equals(this.registeredGatewayArn(), other.registeredGatewayArn()) && Objects.equals(this.coreNetworkId(), other.coreNetworkId()) && Objects.equals(this.awsRegion(), other.awsRegion()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.definitionTimestamp(), other.definitionTimestamp()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasMetadata() == other.hasMetadata() && Objects.equals(this.metadata(), other.metadata());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkResource").add("RegisteredGatewayArn", (Object)this.registeredGatewayArn()).add("CoreNetworkId", (Object)this.coreNetworkId()).add("AwsRegion", (Object)this.awsRegion()).add("AccountId", (Object)this.accountId()).add("ResourceType", (Object)this.resourceType()).add("ResourceId", (Object)this.resourceId()).add("ResourceArn", (Object)this.resourceArn()).add("Definition", (Object)this.definition()).add("DefinitionTimestamp", (Object)this.definitionTimestamp()).add("Tags", this.hasTags() ? this.tags() : null).add("Metadata", this.hasMetadata() ? this.metadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegisteredGatewayArn": {
                return Optional.ofNullable(clazz.cast(this.registeredGatewayArn()));
            }
            case "CoreNetworkId": {
                return Optional.ofNullable(clazz.cast(this.coreNetworkId()));
            }
            case "AwsRegion": {
                return Optional.ofNullable(clazz.cast(this.awsRegion()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "Definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "DefinitionTimestamp": {
                return Optional.ofNullable(clazz.cast(this.definitionTimestamp()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<NetworkResource, T> g) {
        return obj -> g.apply((NetworkResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String registeredGatewayArn;
        private String coreNetworkId;
        private String awsRegion;
        private String accountId;
        private String resourceType;
        private String resourceId;
        private String resourceArn;
        private String definition;
        private Instant definitionTimestamp;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> metadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkResource model) {
            this.registeredGatewayArn(model.registeredGatewayArn);
            this.coreNetworkId(model.coreNetworkId);
            this.awsRegion(model.awsRegion);
            this.accountId(model.accountId);
            this.resourceType(model.resourceType);
            this.resourceId(model.resourceId);
            this.resourceArn(model.resourceArn);
            this.definition(model.definition);
            this.definitionTimestamp(model.definitionTimestamp);
            this.tags(model.tags);
            this.metadata(model.metadata);
        }

        public final String getRegisteredGatewayArn() {
            return this.registeredGatewayArn;
        }

        public final void setRegisteredGatewayArn(String registeredGatewayArn) {
            this.registeredGatewayArn = registeredGatewayArn;
        }

        @Override
        public final Builder registeredGatewayArn(String registeredGatewayArn) {
            this.registeredGatewayArn = registeredGatewayArn;
            return this;
        }

        public final String getCoreNetworkId() {
            return this.coreNetworkId;
        }

        public final void setCoreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
        }

        @Override
        public final Builder coreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        public final String getAwsRegion() {
            return this.awsRegion;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getDefinition() {
            return this.definition;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public final Instant getDefinitionTimestamp() {
            return this.definitionTimestamp;
        }

        public final void setDefinitionTimestamp(Instant definitionTimestamp) {
            this.definitionTimestamp = definitionTimestamp;
        }

        @Override
        public final Builder definitionTimestamp(Instant definitionTimestamp) {
            this.definitionTimestamp = definitionTimestamp;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getMetadata() {
            if (this.metadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.metadata;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = NetworkResourceMetadataMapCopier.copy(metadata);
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = NetworkResourceMetadataMapCopier.copy(metadata);
            return this;
        }

        public NetworkResource build() {
            return new NetworkResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkResource> {
        public Builder registeredGatewayArn(String var1);

        public Builder coreNetworkId(String var1);

        public Builder awsRegion(String var1);

        public Builder accountId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceId(String var1);

        public Builder resourceArn(String var1);

        public Builder definition(String var1);

        public Builder definitionTimestamp(Instant var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder metadata(Map<String, String> var1);
    }
}

