/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkmanager.model.PeeringErrorCode;
import software.amazon.awssdk.services.networkmanager.model.PermissionsErrorContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PeeringError
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PeeringError> {
    private static final SdkField<String> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Code").getter(PeeringError.getter(PeeringError::codeAsString)).setter(PeeringError.setter(Builder::code)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(PeeringError.getter(PeeringError::message)).setter(PeeringError.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(PeeringError.getter(PeeringError::resourceArn)).setter(PeeringError.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(PeeringError.getter(PeeringError::requestId)).setter(PeeringError.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<PermissionsErrorContext> MISSING_PERMISSIONS_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MissingPermissionsContext").getter(PeeringError.getter(PeeringError::missingPermissionsContext)).setter(PeeringError.setter(Builder::missingPermissionsContext)).constructor(PermissionsErrorContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MissingPermissionsContext").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, MESSAGE_FIELD, RESOURCE_ARN_FIELD, REQUEST_ID_FIELD, MISSING_PERMISSIONS_CONTEXT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String code;
    private final String message;
    private final String resourceArn;
    private final String requestId;
    private final PermissionsErrorContext missingPermissionsContext;

    private PeeringError(BuilderImpl builder) {
        this.code = builder.code;
        this.message = builder.message;
        this.resourceArn = builder.resourceArn;
        this.requestId = builder.requestId;
        this.missingPermissionsContext = builder.missingPermissionsContext;
    }

    public final PeeringErrorCode code() {
        return PeeringErrorCode.fromValue(this.code);
    }

    public final String codeAsString() {
        return this.code;
    }

    public final String message() {
        return this.message;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final PermissionsErrorContext missingPermissionsContext() {
        return this.missingPermissionsContext;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.missingPermissionsContext());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PeeringError)) {
            return false;
        }
        PeeringError other = (PeeringError)obj;
        return Objects.equals(this.codeAsString(), other.codeAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.missingPermissionsContext(), other.missingPermissionsContext());
    }

    public final String toString() {
        return ToString.builder((String)"PeeringError").add("Code", (Object)this.codeAsString()).add("Message", (Object)this.message()).add("ResourceArn", (Object)this.resourceArn()).add("RequestId", (Object)this.requestId()).add("MissingPermissionsContext", (Object)this.missingPermissionsContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Code": {
                return Optional.ofNullable(clazz.cast(this.codeAsString()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "MissingPermissionsContext": {
                return Optional.ofNullable(clazz.cast(this.missingPermissionsContext()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PeeringError, T> g) {
        return obj -> g.apply((PeeringError)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String code;
        private String message;
        private String resourceArn;
        private String requestId;
        private PermissionsErrorContext missingPermissionsContext;

        private BuilderImpl() {
        }

        private BuilderImpl(PeeringError model) {
            this.code(model.code);
            this.message(model.message);
            this.resourceArn(model.resourceArn);
            this.requestId(model.requestId);
            this.missingPermissionsContext(model.missingPermissionsContext);
        }

        public final String getCode() {
            return this.code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(PeeringErrorCode code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final PermissionsErrorContext.Builder getMissingPermissionsContext() {
            return this.missingPermissionsContext != null ? this.missingPermissionsContext.toBuilder() : null;
        }

        public final void setMissingPermissionsContext(PermissionsErrorContext.BuilderImpl missingPermissionsContext) {
            this.missingPermissionsContext = missingPermissionsContext != null ? missingPermissionsContext.build() : null;
        }

        @Override
        public final Builder missingPermissionsContext(PermissionsErrorContext missingPermissionsContext) {
            this.missingPermissionsContext = missingPermissionsContext;
            return this;
        }

        public PeeringError build() {
            return new PeeringError(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PeeringError> {
        public Builder code(String var1);

        public Builder code(PeeringErrorCode var1);

        public Builder message(String var1);

        public Builder resourceArn(String var1);

        public Builder requestId(String var1);

        public Builder missingPermissionsContext(PermissionsErrorContext var1);

        default public Builder missingPermissionsContext(Consumer<PermissionsErrorContext.Builder> missingPermissionsContext) {
            return this.missingPermissionsContext((PermissionsErrorContext)((PermissionsErrorContext.Builder)PermissionsErrorContext.builder().applyMutation(missingPermissionsContext)).build());
        }
    }
}

