/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourcePolicyResponse
extends NetworkManagerResponse
implements ToCopyableBuilder<Builder, GetResourcePolicyResponse> {
    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyDocument").getter(GetResourcePolicyResponse.getter(GetResourcePolicyResponse::policyDocument)).setter(GetResourcePolicyResponse.setter(Builder::policyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDocument").build(), JsonValueTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_DOCUMENT_FIELD));
    private final String policyDocument;

    private GetResourcePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policyDocument = builder.policyDocument;
    }

    public final String policyDocument() {
        return this.policyDocument;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocument());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourcePolicyResponse)) {
            return false;
        }
        GetResourcePolicyResponse other = (GetResourcePolicyResponse)((Object)obj);
        return Objects.equals(this.policyDocument(), other.policyDocument());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourcePolicyResponse").add("PolicyDocument", (Object)this.policyDocument()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyDocument": {
                return Optional.ofNullable(clazz.cast(this.policyDocument()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourcePolicyResponse, T> g) {
        return obj -> g.apply((GetResourcePolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkManagerResponse.BuilderImpl
    implements Builder {
        private String policyDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourcePolicyResponse model) {
            super(model);
            this.policyDocument(model.policyDocument);
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        @Override
        public GetResourcePolicyResponse build() {
            return new GetResourcePolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NetworkManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourcePolicyResponse> {
        public Builder policyDocument(String var1);
    }
}

