/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerAsyncClient;
import software.amazon.awssdk.services.networkmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsResponse;
import software.amazon.awssdk.services.networkmanager.model.TransitGatewayRegistration;

public class GetTransitGatewayRegistrationsPublisher
implements SdkPublisher<GetTransitGatewayRegistrationsResponse> {
    private final NetworkManagerAsyncClient client;
    private final GetTransitGatewayRegistrationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetTransitGatewayRegistrationsPublisher(NetworkManagerAsyncClient client, GetTransitGatewayRegistrationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetTransitGatewayRegistrationsPublisher(NetworkManagerAsyncClient client, GetTransitGatewayRegistrationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetTransitGatewayRegistrationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetTransitGatewayRegistrationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TransitGatewayRegistration> transitGatewayRegistrations() {
        Function<GetTransitGatewayRegistrationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.transitGatewayRegistrations() != null) {
                return response.transitGatewayRegistrations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetTransitGatewayRegistrationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetTransitGatewayRegistrationsResponseFetcher
    implements AsyncPageFetcher<GetTransitGatewayRegistrationsResponse> {
        private GetTransitGatewayRegistrationsResponseFetcher() {
        }

        public boolean hasNextPage(GetTransitGatewayRegistrationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetTransitGatewayRegistrationsResponse> nextPage(GetTransitGatewayRegistrationsResponse previousPage) {
            if (previousPage == null) {
                return GetTransitGatewayRegistrationsPublisher.this.client.getTransitGatewayRegistrations(GetTransitGatewayRegistrationsPublisher.this.firstRequest);
            }
            return GetTransitGatewayRegistrationsPublisher.this.client.getTransitGatewayRegistrations((GetTransitGatewayRegistrationsRequest)((Object)GetTransitGatewayRegistrationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

