/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkmanager.model.TunnelProtocol;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectAttachmentOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectAttachmentOptions> {
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(ConnectAttachmentOptions.getter(ConnectAttachmentOptions::protocolAsString)).setter(ConnectAttachmentOptions.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTOCOL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String protocol;

    private ConnectAttachmentOptions(BuilderImpl builder) {
        this.protocol = builder.protocol;
    }

    public final TunnelProtocol protocol() {
        return TunnelProtocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectAttachmentOptions)) {
            return false;
        }
        ConnectAttachmentOptions other = (ConnectAttachmentOptions)obj;
        return Objects.equals(this.protocolAsString(), other.protocolAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectAttachmentOptions").add("Protocol", (Object)this.protocolAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectAttachmentOptions, T> g) {
        return obj -> g.apply((ConnectAttachmentOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectAttachmentOptions model) {
            this.protocol(model.protocol);
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(TunnelProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public ConnectAttachmentOptions build() {
            return new ConnectAttachmentOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectAttachmentOptions> {
        public Builder protocol(String var1);

        public Builder protocol(TunnelProtocol var1);
    }
}

