/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AttachmentState {
    REJECTED("REJECTED"),
    PENDING_ATTACHMENT_ACCEPTANCE("PENDING_ATTACHMENT_ACCEPTANCE"),
    CREATING("CREATING"),
    FAILED("FAILED"),
    AVAILABLE("AVAILABLE"),
    UPDATING("UPDATING"),
    PENDING_NETWORK_UPDATE("PENDING_NETWORK_UPDATE"),
    PENDING_TAG_ACCEPTANCE("PENDING_TAG_ACCEPTANCE"),
    DELETING("DELETING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AttachmentState> VALUE_MAP;
    private final String value;

    private AttachmentState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AttachmentState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AttachmentState> knownValues() {
        EnumSet<AttachmentState> knownValues = EnumSet.allOf(AttachmentState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AttachmentState.class, AttachmentState::toString);
    }
}

