/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerClient;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceRelationshipsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceRelationshipsResponse;
import software.amazon.awssdk.services.networkmanager.model.Relationship;

public class GetNetworkResourceRelationshipsIterable
implements SdkIterable<GetNetworkResourceRelationshipsResponse> {
    private final NetworkManagerClient client;
    private final GetNetworkResourceRelationshipsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetNetworkResourceRelationshipsIterable(NetworkManagerClient client, GetNetworkResourceRelationshipsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetNetworkResourceRelationshipsResponseFetcher();
    }

    public Iterator<GetNetworkResourceRelationshipsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Relationship> relationships() {
        Function<GetNetworkResourceRelationshipsResponse, Iterator> getIterator = response -> {
            if (response != null && response.relationships() != null) {
                return response.relationships().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetNetworkResourceRelationshipsResponseFetcher
    implements SyncPageFetcher<GetNetworkResourceRelationshipsResponse> {
        private GetNetworkResourceRelationshipsResponseFetcher() {
        }

        public boolean hasNextPage(GetNetworkResourceRelationshipsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetNetworkResourceRelationshipsResponse nextPage(GetNetworkResourceRelationshipsResponse previousPage) {
            if (previousPage == null) {
                return GetNetworkResourceRelationshipsIterable.this.client.getNetworkResourceRelationships(GetNetworkResourceRelationshipsIterable.this.firstRequest);
            }
            return GetNetworkResourceRelationshipsIterable.this.client.getNetworkResourceRelationships((GetNetworkResourceRelationshipsRequest)((Object)GetNetworkResourceRelationshipsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

