/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum GlobalNetworkState {
    PENDING("PENDING"),
    AVAILABLE("AVAILABLE"),
    DELETING("DELETING"),
    UPDATING("UPDATING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, GlobalNetworkState> VALUE_MAP;
    private final String value;

    private GlobalNetworkState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static GlobalNetworkState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<GlobalNetworkState> knownValues() {
        EnumSet<GlobalNetworkState> knownValues = EnumSet.allOf(GlobalNetworkState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(GlobalNetworkState.class, GlobalNetworkState::toString);
    }
}

