/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerRequest;
import software.amazon.awssdk.services.networkmanager.model.Tag;
import software.amazon.awssdk.services.networkmanager.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTransitGatewayRouteTableAttachmentRequest
extends NetworkManagerRequest
implements ToCopyableBuilder<Builder, CreateTransitGatewayRouteTableAttachmentRequest> {
    private static final SdkField<String> PEERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PeeringId").getter(CreateTransitGatewayRouteTableAttachmentRequest.getter(CreateTransitGatewayRouteTableAttachmentRequest::peeringId)).setter(CreateTransitGatewayRouteTableAttachmentRequest.setter(Builder::peeringId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeeringId").build()}).build();
    private static final SdkField<String> TRANSIT_GATEWAY_ROUTE_TABLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayRouteTableArn").getter(CreateTransitGatewayRouteTableAttachmentRequest.getter(CreateTransitGatewayRouteTableAttachmentRequest::transitGatewayRouteTableArn)).setter(CreateTransitGatewayRouteTableAttachmentRequest.setter(Builder::transitGatewayRouteTableArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayRouteTableArn").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateTransitGatewayRouteTableAttachmentRequest.getter(CreateTransitGatewayRouteTableAttachmentRequest::tags)).setter(CreateTransitGatewayRouteTableAttachmentRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateTransitGatewayRouteTableAttachmentRequest.getter(CreateTransitGatewayRouteTableAttachmentRequest::clientToken)).setter(CreateTransitGatewayRouteTableAttachmentRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PEERING_ID_FIELD, TRANSIT_GATEWAY_ROUTE_TABLE_ARN_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));
    private final String peeringId;
    private final String transitGatewayRouteTableArn;
    private final List<Tag> tags;
    private final String clientToken;

    private CreateTransitGatewayRouteTableAttachmentRequest(BuilderImpl builder) {
        super(builder);
        this.peeringId = builder.peeringId;
        this.transitGatewayRouteTableArn = builder.transitGatewayRouteTableArn;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    public final String peeringId() {
        return this.peeringId;
    }

    public final String transitGatewayRouteTableArn() {
        return this.transitGatewayRouteTableArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.peeringId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayRouteTableArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTransitGatewayRouteTableAttachmentRequest)) {
            return false;
        }
        CreateTransitGatewayRouteTableAttachmentRequest other = (CreateTransitGatewayRouteTableAttachmentRequest)((Object)obj);
        return Objects.equals(this.peeringId(), other.peeringId()) && Objects.equals(this.transitGatewayRouteTableArn(), other.transitGatewayRouteTableArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTransitGatewayRouteTableAttachmentRequest").add("PeeringId", (Object)this.peeringId()).add("TransitGatewayRouteTableArn", (Object)this.transitGatewayRouteTableArn()).add("Tags", this.hasTags() ? this.tags() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PeeringId": {
                return Optional.ofNullable(clazz.cast(this.peeringId()));
            }
            case "TransitGatewayRouteTableArn": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayRouteTableArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTransitGatewayRouteTableAttachmentRequest, T> g) {
        return obj -> g.apply((CreateTransitGatewayRouteTableAttachmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkManagerRequest.BuilderImpl
    implements Builder {
        private String peeringId;
        private String transitGatewayRouteTableArn;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTransitGatewayRouteTableAttachmentRequest model) {
            super(model);
            this.peeringId(model.peeringId);
            this.transitGatewayRouteTableArn(model.transitGatewayRouteTableArn);
            this.tags(model.tags);
            this.clientToken(model.clientToken);
        }

        public final String getPeeringId() {
            return this.peeringId;
        }

        public final void setPeeringId(String peeringId) {
            this.peeringId = peeringId;
        }

        @Override
        public final Builder peeringId(String peeringId) {
            this.peeringId = peeringId;
            return this;
        }

        public final String getTransitGatewayRouteTableArn() {
            return this.transitGatewayRouteTableArn;
        }

        public final void setTransitGatewayRouteTableArn(String transitGatewayRouteTableArn) {
            this.transitGatewayRouteTableArn = transitGatewayRouteTableArn;
        }

        @Override
        public final Builder transitGatewayRouteTableArn(String transitGatewayRouteTableArn) {
            this.transitGatewayRouteTableArn = transitGatewayRouteTableArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTransitGatewayRouteTableAttachmentRequest build() {
            return new CreateTransitGatewayRouteTableAttachmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NetworkManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTransitGatewayRouteTableAttachmentRequest> {
        public Builder peeringId(String var1);

        public Builder transitGatewayRouteTableArn(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

