/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerResponse;
import software.amazon.awssdk.services.networkmanager.model.TransitGatewayRegistration;
import software.amazon.awssdk.services.networkmanager.model.TransitGatewayRegistrationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTransitGatewayRegistrationsResponse
extends NetworkManagerResponse
implements ToCopyableBuilder<Builder, GetTransitGatewayRegistrationsResponse> {
    private static final SdkField<List<TransitGatewayRegistration>> TRANSIT_GATEWAY_REGISTRATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TransitGatewayRegistrations").getter(GetTransitGatewayRegistrationsResponse.getter(GetTransitGatewayRegistrationsResponse::transitGatewayRegistrations)).setter(GetTransitGatewayRegistrationsResponse.setter(Builder::transitGatewayRegistrations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayRegistrations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransitGatewayRegistration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetTransitGatewayRegistrationsResponse.getter(GetTransitGatewayRegistrationsResponse::nextToken)).setter(GetTransitGatewayRegistrationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_REGISTRATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<TransitGatewayRegistration> transitGatewayRegistrations;
    private final String nextToken;

    private GetTransitGatewayRegistrationsResponse(BuilderImpl builder) {
        super(builder);
        this.transitGatewayRegistrations = builder.transitGatewayRegistrations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTransitGatewayRegistrations() {
        return this.transitGatewayRegistrations != null && !(this.transitGatewayRegistrations instanceof SdkAutoConstructList);
    }

    public final List<TransitGatewayRegistration> transitGatewayRegistrations() {
        return this.transitGatewayRegistrations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransitGatewayRegistrations() ? this.transitGatewayRegistrations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTransitGatewayRegistrationsResponse)) {
            return false;
        }
        GetTransitGatewayRegistrationsResponse other = (GetTransitGatewayRegistrationsResponse)((Object)obj);
        return this.hasTransitGatewayRegistrations() == other.hasTransitGatewayRegistrations() && Objects.equals(this.transitGatewayRegistrations(), other.transitGatewayRegistrations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetTransitGatewayRegistrationsResponse").add("TransitGatewayRegistrations", this.hasTransitGatewayRegistrations() ? this.transitGatewayRegistrations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayRegistrations": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayRegistrations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTransitGatewayRegistrationsResponse, T> g) {
        return obj -> g.apply((GetTransitGatewayRegistrationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkManagerResponse.BuilderImpl
    implements Builder {
        private List<TransitGatewayRegistration> transitGatewayRegistrations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTransitGatewayRegistrationsResponse model) {
            super(model);
            this.transitGatewayRegistrations(model.transitGatewayRegistrations);
            this.nextToken(model.nextToken);
        }

        public final List<TransitGatewayRegistration.Builder> getTransitGatewayRegistrations() {
            List<TransitGatewayRegistration.Builder> result = TransitGatewayRegistrationListCopier.copyToBuilder(this.transitGatewayRegistrations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransitGatewayRegistrations(Collection<TransitGatewayRegistration.BuilderImpl> transitGatewayRegistrations) {
            this.transitGatewayRegistrations = TransitGatewayRegistrationListCopier.copyFromBuilder(transitGatewayRegistrations);
        }

        @Override
        public final Builder transitGatewayRegistrations(Collection<TransitGatewayRegistration> transitGatewayRegistrations) {
            this.transitGatewayRegistrations = TransitGatewayRegistrationListCopier.copy(transitGatewayRegistrations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayRegistrations(TransitGatewayRegistration ... transitGatewayRegistrations) {
            this.transitGatewayRegistrations(Arrays.asList(transitGatewayRegistrations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayRegistrations(Consumer<TransitGatewayRegistration.Builder> ... transitGatewayRegistrations) {
            this.transitGatewayRegistrations(Stream.of(transitGatewayRegistrations).map(c -> (TransitGatewayRegistration)((TransitGatewayRegistration.Builder)TransitGatewayRegistration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetTransitGatewayRegistrationsResponse build() {
            return new GetTransitGatewayRegistrationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NetworkManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTransitGatewayRegistrationsResponse> {
        public Builder transitGatewayRegistrations(Collection<TransitGatewayRegistration> var1);

        public Builder transitGatewayRegistrations(TransitGatewayRegistration ... var1);

        public Builder transitGatewayRegistrations(Consumer<TransitGatewayRegistration.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

