/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AttachmentType {
    CONNECT("CONNECT"),
    SITE_TO_SITE_VPN("SITE_TO_SITE_VPN"),
    VPC("VPC"),
    TRANSIT_GATEWAY_ROUTE_TABLE("TRANSIT_GATEWAY_ROUTE_TABLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AttachmentType> VALUE_MAP;
    private final String value;

    private AttachmentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AttachmentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AttachmentType> knownValues() {
        EnumSet<AttachmentType> knownValues = EnumSet.allOf(AttachmentType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AttachmentType.class, AttachmentType::toString);
    }
}

