/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerClient;
import software.amazon.awssdk.services.networkmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkResourcesRequest;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkResourcesResponse;
import software.amazon.awssdk.services.networkmanager.model.NetworkResource;

public class GetNetworkResourcesIterable
implements SdkIterable<GetNetworkResourcesResponse> {
    private final NetworkManagerClient client;
    private final GetNetworkResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetNetworkResourcesIterable(NetworkManagerClient client, GetNetworkResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetNetworkResourcesResponseFetcher();
    }

    public Iterator<GetNetworkResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<NetworkResource> networkResources() {
        Function<GetNetworkResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.networkResources() != null) {
                return response.networkResources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetNetworkResourcesResponseFetcher
    implements SyncPageFetcher<GetNetworkResourcesResponse> {
        private GetNetworkResourcesResponseFetcher() {
        }

        public boolean hasNextPage(GetNetworkResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetNetworkResourcesResponse nextPage(GetNetworkResourcesResponse previousPage) {
            if (previousPage == null) {
                return GetNetworkResourcesIterable.this.client.getNetworkResources(GetNetworkResourcesIterable.this.firstRequest);
            }
            return GetNetworkResourcesIterable.this.client.getNetworkResources((GetNetworkResourcesRequest)((Object)GetNetworkResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

