/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkmanager.model.Attachment;
import software.amazon.awssdk.services.networkmanager.model.ConnectAttachmentOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectAttachment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectAttachment> {
    private static final SdkField<Attachment> ATTACHMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Attachment").getter(ConnectAttachment.getter(ConnectAttachment::attachment)).setter(ConnectAttachment.setter(Builder::attachment)).constructor(Attachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachment").build()}).build();
    private static final SdkField<String> TRANSPORT_ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransportAttachmentId").getter(ConnectAttachment.getter(ConnectAttachment::transportAttachmentId)).setter(ConnectAttachment.setter(Builder::transportAttachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransportAttachmentId").build()}).build();
    private static final SdkField<ConnectAttachmentOptions> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Options").getter(ConnectAttachment.getter(ConnectAttachment::options)).setter(ConnectAttachment.setter(Builder::options)).constructor(ConnectAttachmentOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_FIELD, TRANSPORT_ATTACHMENT_ID_FIELD, OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Attachment attachment;
    private final String transportAttachmentId;
    private final ConnectAttachmentOptions options;

    private ConnectAttachment(BuilderImpl builder) {
        this.attachment = builder.attachment;
        this.transportAttachmentId = builder.transportAttachmentId;
        this.options = builder.options;
    }

    public final Attachment attachment() {
        return this.attachment;
    }

    public final String transportAttachmentId() {
        return this.transportAttachmentId;
    }

    public final ConnectAttachmentOptions options() {
        return this.options;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachment());
        hashCode = 31 * hashCode + Objects.hashCode(this.transportAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectAttachment)) {
            return false;
        }
        ConnectAttachment other = (ConnectAttachment)obj;
        return Objects.equals(this.attachment(), other.attachment()) && Objects.equals(this.transportAttachmentId(), other.transportAttachmentId()) && Objects.equals(this.options(), other.options());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectAttachment").add("Attachment", (Object)this.attachment()).add("TransportAttachmentId", (Object)this.transportAttachmentId()).add("Options", (Object)this.options()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attachment": {
                return Optional.ofNullable(clazz.cast(this.attachment()));
            }
            case "TransportAttachmentId": {
                return Optional.ofNullable(clazz.cast(this.transportAttachmentId()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectAttachment, T> g) {
        return obj -> g.apply((ConnectAttachment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Attachment attachment;
        private String transportAttachmentId;
        private ConnectAttachmentOptions options;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectAttachment model) {
            this.attachment(model.attachment);
            this.transportAttachmentId(model.transportAttachmentId);
            this.options(model.options);
        }

        public final Attachment.Builder getAttachment() {
            return this.attachment != null ? this.attachment.toBuilder() : null;
        }

        public final void setAttachment(Attachment.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        @Override
        public final Builder attachment(Attachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public final String getTransportAttachmentId() {
            return this.transportAttachmentId;
        }

        public final void setTransportAttachmentId(String transportAttachmentId) {
            this.transportAttachmentId = transportAttachmentId;
        }

        @Override
        public final Builder transportAttachmentId(String transportAttachmentId) {
            this.transportAttachmentId = transportAttachmentId;
            return this;
        }

        public final ConnectAttachmentOptions.Builder getOptions() {
            return this.options != null ? this.options.toBuilder() : null;
        }

        public final void setOptions(ConnectAttachmentOptions.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public final Builder options(ConnectAttachmentOptions options) {
            this.options = options;
            return this;
        }

        public ConnectAttachment build() {
            return new ConnectAttachment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectAttachment> {
        public Builder attachment(Attachment var1);

        default public Builder attachment(Consumer<Attachment.Builder> attachment) {
            return this.attachment((Attachment)((Attachment.Builder)Attachment.builder().applyMutation(attachment)).build());
        }

        public Builder transportAttachmentId(String var1);

        public Builder options(ConnectAttachmentOptions var1);

        default public Builder options(Consumer<ConnectAttachmentOptions.Builder> options) {
            return this.options((ConnectAttachmentOptions)((ConnectAttachmentOptions.Builder)ConnectAttachmentOptions.builder().applyMutation(options)).build());
        }
    }
}

