/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a core network Connect attachment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectAttachment implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectAttachment.Builder, ConnectAttachment> {
    private static final SdkField<Attachment> ATTACHMENT_FIELD = SdkField.<Attachment> builder(MarshallingType.SDK_POJO)
            .memberName("Attachment").getter(getter(ConnectAttachment::attachment)).setter(setter(Builder::attachment))
            .constructor(Attachment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachment").build()).build();

    private static final SdkField<String> TRANSPORT_ATTACHMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransportAttachmentId").getter(getter(ConnectAttachment::transportAttachmentId))
            .setter(setter(Builder::transportAttachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransportAttachmentId").build())
            .build();

    private static final SdkField<ConnectAttachmentOptions> OPTIONS_FIELD = SdkField
            .<ConnectAttachmentOptions> builder(MarshallingType.SDK_POJO).memberName("Options")
            .getter(getter(ConnectAttachment::options)).setter(setter(Builder::options))
            .constructor(ConnectAttachmentOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_FIELD,
            TRANSPORT_ATTACHMENT_ID_FIELD, OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Attachment attachment;

    private final String transportAttachmentId;

    private final ConnectAttachmentOptions options;

    private ConnectAttachment(BuilderImpl builder) {
        this.attachment = builder.attachment;
        this.transportAttachmentId = builder.transportAttachmentId;
        this.options = builder.options;
    }

    /**
     * <p>
     * The attachment details.
     * </p>
     * 
     * @return The attachment details.
     */
    public final Attachment attachment() {
        return attachment;
    }

    /**
     * <p>
     * The ID of the transport attachment.
     * </p>
     * 
     * @return The ID of the transport attachment.
     */
    public final String transportAttachmentId() {
        return transportAttachmentId;
    }

    /**
     * <p>
     * Options for connecting an attachment.
     * </p>
     * 
     * @return Options for connecting an attachment.
     */
    public final ConnectAttachmentOptions options() {
        return options;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachment());
        hashCode = 31 * hashCode + Objects.hashCode(transportAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(options());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectAttachment)) {
            return false;
        }
        ConnectAttachment other = (ConnectAttachment) obj;
        return Objects.equals(attachment(), other.attachment())
                && Objects.equals(transportAttachmentId(), other.transportAttachmentId())
                && Objects.equals(options(), other.options());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectAttachment").add("Attachment", attachment())
                .add("TransportAttachmentId", transportAttachmentId()).add("Options", options()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attachment":
            return Optional.ofNullable(clazz.cast(attachment()));
        case "TransportAttachmentId":
            return Optional.ofNullable(clazz.cast(transportAttachmentId()));
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectAttachment, T> g) {
        return obj -> g.apply((ConnectAttachment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectAttachment> {
        /**
         * <p>
         * The attachment details.
         * </p>
         * 
         * @param attachment
         *        The attachment details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachment(Attachment attachment);

        /**
         * <p>
         * The attachment details.
         * </p>
         * This is a convenience method that creates an instance of the {@link Attachment.Builder} avoiding the need to
         * create one manually via {@link Attachment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Attachment.Builder#build()} is called immediately and its result
         * is passed to {@link #attachment(Attachment)}.
         * 
         * @param attachment
         *        a consumer that will call methods on {@link Attachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachment(Attachment)
         */
        default Builder attachment(Consumer<Attachment.Builder> attachment) {
            return attachment(Attachment.builder().applyMutation(attachment).build());
        }

        /**
         * <p>
         * The ID of the transport attachment.
         * </p>
         * 
         * @param transportAttachmentId
         *        The ID of the transport attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transportAttachmentId(String transportAttachmentId);

        /**
         * <p>
         * Options for connecting an attachment.
         * </p>
         * 
         * @param options
         *        Options for connecting an attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(ConnectAttachmentOptions options);

        /**
         * <p>
         * Options for connecting an attachment.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectAttachmentOptions.Builder}
         * avoiding the need to create one manually via {@link ConnectAttachmentOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectAttachmentOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #options(ConnectAttachmentOptions)}.
         * 
         * @param options
         *        a consumer that will call methods on {@link ConnectAttachmentOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(ConnectAttachmentOptions)
         */
        default Builder options(Consumer<ConnectAttachmentOptions.Builder> options) {
            return options(ConnectAttachmentOptions.builder().applyMutation(options).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Attachment attachment;

        private String transportAttachmentId;

        private ConnectAttachmentOptions options;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectAttachment model) {
            attachment(model.attachment);
            transportAttachmentId(model.transportAttachmentId);
            options(model.options);
        }

        public final Attachment.Builder getAttachment() {
            return attachment != null ? attachment.toBuilder() : null;
        }

        public final void setAttachment(Attachment.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        @Override
        public final Builder attachment(Attachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public final String getTransportAttachmentId() {
            return transportAttachmentId;
        }

        public final void setTransportAttachmentId(String transportAttachmentId) {
            this.transportAttachmentId = transportAttachmentId;
        }

        @Override
        public final Builder transportAttachmentId(String transportAttachmentId) {
            this.transportAttachmentId = transportAttachmentId;
            return this;
        }

        public final ConnectAttachmentOptions.Builder getOptions() {
            return options != null ? options.toBuilder() : null;
        }

        public final void setOptions(ConnectAttachmentOptions.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public final Builder options(ConnectAttachmentOptions options) {
            this.options = options;
            return this;
        }

        @Override
        public ConnectAttachment build() {
            return new ConnectAttachment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
