/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutCoreNetworkPolicyRequest
extends NetworkManagerRequest
implements ToCopyableBuilder<Builder, PutCoreNetworkPolicyRequest> {
    private static final SdkField<String> CORE_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CoreNetworkId").getter(PutCoreNetworkPolicyRequest.getter(PutCoreNetworkPolicyRequest::coreNetworkId)).setter(PutCoreNetworkPolicyRequest.setter(Builder::coreNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("coreNetworkId").build()}).build();
    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyDocument").getter(PutCoreNetworkPolicyRequest.getter(PutCoreNetworkPolicyRequest::policyDocument)).setter(PutCoreNetworkPolicyRequest.setter(Builder::policyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDocument").build(), JsonValueTrait.create()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(PutCoreNetworkPolicyRequest.getter(PutCoreNetworkPolicyRequest::description)).setter(PutCoreNetworkPolicyRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Integer> LATEST_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("LatestVersionId").getter(PutCoreNetworkPolicyRequest.getter(PutCoreNetworkPolicyRequest::latestVersionId)).setter(PutCoreNetworkPolicyRequest.setter(Builder::latestVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersionId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(PutCoreNetworkPolicyRequest.getter(PutCoreNetworkPolicyRequest::clientToken)).setter(PutCoreNetworkPolicyRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_NETWORK_ID_FIELD, POLICY_DOCUMENT_FIELD, DESCRIPTION_FIELD, LATEST_VERSION_ID_FIELD, CLIENT_TOKEN_FIELD));
    private final String coreNetworkId;
    private final String policyDocument;
    private final String description;
    private final Integer latestVersionId;
    private final String clientToken;

    private PutCoreNetworkPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.coreNetworkId = builder.coreNetworkId;
        this.policyDocument = builder.policyDocument;
        this.description = builder.description;
        this.latestVersionId = builder.latestVersionId;
        this.clientToken = builder.clientToken;
    }

    public final String coreNetworkId() {
        return this.coreNetworkId;
    }

    public final String policyDocument() {
        return this.policyDocument;
    }

    public final String description() {
        return this.description;
    }

    public final Integer latestVersionId() {
        return this.latestVersionId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.coreNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutCoreNetworkPolicyRequest)) {
            return false;
        }
        PutCoreNetworkPolicyRequest other = (PutCoreNetworkPolicyRequest)((Object)obj);
        return Objects.equals(this.coreNetworkId(), other.coreNetworkId()) && Objects.equals(this.policyDocument(), other.policyDocument()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.latestVersionId(), other.latestVersionId()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"PutCoreNetworkPolicyRequest").add("CoreNetworkId", (Object)this.coreNetworkId()).add("PolicyDocument", (Object)this.policyDocument()).add("Description", (Object)this.description()).add("LatestVersionId", (Object)this.latestVersionId()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CoreNetworkId": {
                return Optional.ofNullable(clazz.cast(this.coreNetworkId()));
            }
            case "PolicyDocument": {
                return Optional.ofNullable(clazz.cast(this.policyDocument()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "LatestVersionId": {
                return Optional.ofNullable(clazz.cast(this.latestVersionId()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutCoreNetworkPolicyRequest, T> g) {
        return obj -> g.apply((PutCoreNetworkPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkManagerRequest.BuilderImpl
    implements Builder {
        private String coreNetworkId;
        private String policyDocument;
        private String description;
        private Integer latestVersionId;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(PutCoreNetworkPolicyRequest model) {
            super(model);
            this.coreNetworkId(model.coreNetworkId);
            this.policyDocument(model.policyDocument);
            this.description(model.description);
            this.latestVersionId(model.latestVersionId);
            this.clientToken(model.clientToken);
        }

        public final String getCoreNetworkId() {
            return this.coreNetworkId;
        }

        public final void setCoreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
        }

        @Override
        @Transient
        public final Builder coreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        @Transient
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getLatestVersionId() {
            return this.latestVersionId;
        }

        public final void setLatestVersionId(Integer latestVersionId) {
            this.latestVersionId = latestVersionId;
        }

        @Override
        @Transient
        public final Builder latestVersionId(Integer latestVersionId) {
            this.latestVersionId = latestVersionId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutCoreNetworkPolicyRequest build() {
            return new PutCoreNetworkPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NetworkManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutCoreNetworkPolicyRequest> {
        public Builder coreNetworkId(String var1);

        public Builder policyDocument(String var1);

        public Builder description(String var1);

        public Builder latestVersionId(Integer var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

