/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerAsyncClient;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkResourcesRequest;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkResourcesResponse;
import software.amazon.awssdk.services.networkmanager.model.NetworkResource;

public class GetNetworkResourcesPublisher
implements SdkPublisher<GetNetworkResourcesResponse> {
    private final NetworkManagerAsyncClient client;
    private final GetNetworkResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetNetworkResourcesPublisher(NetworkManagerAsyncClient client, GetNetworkResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetNetworkResourcesPublisher(NetworkManagerAsyncClient client, GetNetworkResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetNetworkResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetNetworkResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<NetworkResource> networkResources() {
        Function<GetNetworkResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.networkResources() != null) {
                return response.networkResources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetNetworkResourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetNetworkResourcesResponseFetcher
    implements AsyncPageFetcher<GetNetworkResourcesResponse> {
        private GetNetworkResourcesResponseFetcher() {
        }

        public boolean hasNextPage(GetNetworkResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetNetworkResourcesResponse> nextPage(GetNetworkResourcesResponse previousPage) {
            if (previousPage == null) {
                return GetNetworkResourcesPublisher.this.client.getNetworkResources(GetNetworkResourcesPublisher.this.firstRequest);
            }
            return GetNetworkResourcesPublisher.this.client.getNetworkResources((GetNetworkResourcesRequest)((Object)GetNetworkResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

