/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerClient;
import software.amazon.awssdk.services.networkmanager.model.CoreNetworkSummary;
import software.amazon.awssdk.services.networkmanager.model.ListCoreNetworksRequest;
import software.amazon.awssdk.services.networkmanager.model.ListCoreNetworksResponse;

public class ListCoreNetworksIterable
implements SdkIterable<ListCoreNetworksResponse> {
    private final NetworkManagerClient client;
    private final ListCoreNetworksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCoreNetworksIterable(NetworkManagerClient client, ListCoreNetworksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCoreNetworksResponseFetcher();
    }

    public Iterator<ListCoreNetworksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CoreNetworkSummary> coreNetworks() {
        Function<ListCoreNetworksResponse, Iterator> getIterator = response -> {
            if (response != null && response.coreNetworks() != null) {
                return response.coreNetworks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCoreNetworksResponseFetcher
    implements SyncPageFetcher<ListCoreNetworksResponse> {
        private ListCoreNetworksResponseFetcher() {
        }

        public boolean hasNextPage(ListCoreNetworksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCoreNetworksResponse nextPage(ListCoreNetworksResponse previousPage) {
            if (previousPage == null) {
                return ListCoreNetworksIterable.this.client.listCoreNetworks(ListCoreNetworksIterable.this.firstRequest);
            }
            return ListCoreNetworksIterable.this.client.listCoreNetworks((ListCoreNetworksRequest)((Object)ListCoreNetworksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

