/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerAsyncClient;
import software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsResponse;
import software.amazon.awssdk.services.networkmanager.model.LinkAssociation;

public class GetLinkAssociationsPublisher
implements SdkPublisher<GetLinkAssociationsResponse> {
    private final NetworkManagerAsyncClient client;
    private final GetLinkAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetLinkAssociationsPublisher(NetworkManagerAsyncClient client, GetLinkAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetLinkAssociationsPublisher(NetworkManagerAsyncClient client, GetLinkAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetLinkAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetLinkAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LinkAssociation> linkAssociations() {
        Function<GetLinkAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.linkAssociations() != null) {
                return response.linkAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetLinkAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetLinkAssociationsResponseFetcher
    implements AsyncPageFetcher<GetLinkAssociationsResponse> {
        private GetLinkAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(GetLinkAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetLinkAssociationsResponse> nextPage(GetLinkAssociationsResponse previousPage) {
            if (previousPage == null) {
                return GetLinkAssociationsPublisher.this.client.getLinkAssociations(GetLinkAssociationsPublisher.this.firstRequest);
            }
            return GetLinkAssociationsPublisher.this.client.getLinkAssociations((GetLinkAssociationsRequest)((Object)GetLinkAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

