/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerClient;
import software.amazon.awssdk.services.networkmanager.model.CoreNetworkChange;
import software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetRequest;
import software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetResponse;

public class GetCoreNetworkChangeSetIterable
implements SdkIterable<GetCoreNetworkChangeSetResponse> {
    private final NetworkManagerClient client;
    private final GetCoreNetworkChangeSetRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetCoreNetworkChangeSetIterable(NetworkManagerClient client, GetCoreNetworkChangeSetRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetCoreNetworkChangeSetResponseFetcher();
    }

    public Iterator<GetCoreNetworkChangeSetResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CoreNetworkChange> coreNetworkChanges() {
        Function<GetCoreNetworkChangeSetResponse, Iterator> getIterator = response -> {
            if (response != null && response.coreNetworkChanges() != null) {
                return response.coreNetworkChanges().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetCoreNetworkChangeSetResponseFetcher
    implements SyncPageFetcher<GetCoreNetworkChangeSetResponse> {
        private GetCoreNetworkChangeSetResponseFetcher() {
        }

        public boolean hasNextPage(GetCoreNetworkChangeSetResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetCoreNetworkChangeSetResponse nextPage(GetCoreNetworkChangeSetResponse previousPage) {
            if (previousPage == null) {
                return GetCoreNetworkChangeSetIterable.this.client.getCoreNetworkChangeSet(GetCoreNetworkChangeSetIterable.this.firstRequest);
            }
            return GetCoreNetworkChangeSetIterable.this.client.getCoreNetworkChangeSet((GetCoreNetworkChangeSetRequest)((Object)GetCoreNetworkChangeSetIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

