/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.ConnectPeerAssociation;
import software.amazon.awssdk.services.networkmanager.model.ConnectPeerAssociationListCopier;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConnectPeerAssociationsResponse
extends NetworkManagerResponse
implements ToCopyableBuilder<Builder, GetConnectPeerAssociationsResponse> {
    private static final SdkField<List<ConnectPeerAssociation>> CONNECT_PEER_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConnectPeerAssociations").getter(GetConnectPeerAssociationsResponse.getter(GetConnectPeerAssociationsResponse::connectPeerAssociations)).setter(GetConnectPeerAssociationsResponse.setter(Builder::connectPeerAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectPeerAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConnectPeerAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetConnectPeerAssociationsResponse.getter(GetConnectPeerAssociationsResponse::nextToken)).setter(GetConnectPeerAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECT_PEER_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ConnectPeerAssociation> connectPeerAssociations;
    private final String nextToken;

    private GetConnectPeerAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.connectPeerAssociations = builder.connectPeerAssociations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasConnectPeerAssociations() {
        return this.connectPeerAssociations != null && !(this.connectPeerAssociations instanceof SdkAutoConstructList);
    }

    public final List<ConnectPeerAssociation> connectPeerAssociations() {
        return this.connectPeerAssociations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectPeerAssociations() ? this.connectPeerAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectPeerAssociationsResponse)) {
            return false;
        }
        GetConnectPeerAssociationsResponse other = (GetConnectPeerAssociationsResponse)((Object)obj);
        return this.hasConnectPeerAssociations() == other.hasConnectPeerAssociations() && Objects.equals(this.connectPeerAssociations(), other.connectPeerAssociations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetConnectPeerAssociationsResponse").add("ConnectPeerAssociations", this.hasConnectPeerAssociations() ? this.connectPeerAssociations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectPeerAssociations": {
                return Optional.ofNullable(clazz.cast(this.connectPeerAssociations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConnectPeerAssociationsResponse, T> g) {
        return obj -> g.apply((GetConnectPeerAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkManagerResponse.BuilderImpl
    implements Builder {
        private List<ConnectPeerAssociation> connectPeerAssociations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConnectPeerAssociationsResponse model) {
            super(model);
            this.connectPeerAssociations(model.connectPeerAssociations);
            this.nextToken(model.nextToken);
        }

        public final List<ConnectPeerAssociation.Builder> getConnectPeerAssociations() {
            List<ConnectPeerAssociation.Builder> result = ConnectPeerAssociationListCopier.copyToBuilder(this.connectPeerAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnectPeerAssociations(Collection<ConnectPeerAssociation.BuilderImpl> connectPeerAssociations) {
            this.connectPeerAssociations = ConnectPeerAssociationListCopier.copyFromBuilder(connectPeerAssociations);
        }

        @Override
        public final Builder connectPeerAssociations(Collection<ConnectPeerAssociation> connectPeerAssociations) {
            this.connectPeerAssociations = ConnectPeerAssociationListCopier.copy(connectPeerAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectPeerAssociations(ConnectPeerAssociation ... connectPeerAssociations) {
            this.connectPeerAssociations(Arrays.asList(connectPeerAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectPeerAssociations(Consumer<ConnectPeerAssociation.Builder> ... connectPeerAssociations) {
            this.connectPeerAssociations(Stream.of(connectPeerAssociations).map(c -> (ConnectPeerAssociation)((ConnectPeerAssociation.Builder)ConnectPeerAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetConnectPeerAssociationsResponse build() {
            return new GetConnectPeerAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NetworkManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetConnectPeerAssociationsResponse> {
        public Builder connectPeerAssociations(Collection<ConnectPeerAssociation> var1);

        public Builder connectPeerAssociations(ConnectPeerAssociation ... var1);

        public Builder connectPeerAssociations(Consumer<ConnectPeerAssociation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

