/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerClient;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceCountsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceCountsResponse;
import software.amazon.awssdk.services.networkmanager.model.NetworkResourceCount;

public class GetNetworkResourceCountsIterable
implements SdkIterable<GetNetworkResourceCountsResponse> {
    private final NetworkManagerClient client;
    private final GetNetworkResourceCountsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetNetworkResourceCountsIterable(NetworkManagerClient client, GetNetworkResourceCountsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetNetworkResourceCountsResponseFetcher();
    }

    public Iterator<GetNetworkResourceCountsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<NetworkResourceCount> networkResourceCounts() {
        Function<GetNetworkResourceCountsResponse, Iterator> getIterator = response -> {
            if (response != null && response.networkResourceCounts() != null) {
                return response.networkResourceCounts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetNetworkResourceCountsResponseFetcher
    implements SyncPageFetcher<GetNetworkResourceCountsResponse> {
        private GetNetworkResourceCountsResponseFetcher() {
        }

        public boolean hasNextPage(GetNetworkResourceCountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetNetworkResourceCountsResponse nextPage(GetNetworkResourceCountsResponse previousPage) {
            if (previousPage == null) {
                return GetNetworkResourceCountsIterable.this.client.getNetworkResourceCounts(GetNetworkResourceCountsIterable.this.firstRequest);
            }
            return GetNetworkResourceCountsIterable.this.client.getNetworkResourceCounts((GetNetworkResourceCountsRequest)((Object)GetNetworkResourceCountsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

