/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ChangeSetState {
    PENDING_GENERATION("PENDING_GENERATION"),
    FAILED_GENERATION("FAILED_GENERATION"),
    READY_TO_EXECUTE("READY_TO_EXECUTE"),
    EXECUTING("EXECUTING"),
    EXECUTION_SUCCEEDED("EXECUTION_SUCCEEDED"),
    OUT_OF_DATE("OUT_OF_DATE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ChangeSetState> VALUE_MAP;
    private final String value;

    private ChangeSetState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ChangeSetState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ChangeSetState> knownValues() {
        EnumSet<ChangeSetState> knownValues = EnumSet.allOf(ChangeSetState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ChangeSetState.class, ChangeSetState::toString);
    }
}

