/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.LinkIdListCopier;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLinksRequest
extends NetworkManagerRequest
implements ToCopyableBuilder<Builder, GetLinksRequest> {
    private static final SdkField<String> GLOBAL_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalNetworkId").getter(GetLinksRequest.getter(GetLinksRequest::globalNetworkId)).setter(GetLinksRequest.setter(Builder::globalNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("globalNetworkId").build()}).build();
    private static final SdkField<List<String>> LINK_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LinkIds").getter(GetLinksRequest.getter(GetLinksRequest::linkIds)).setter(GetLinksRequest.setter(Builder::linkIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("linkIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SITE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SiteId").getter(GetLinksRequest.getter(GetLinksRequest::siteId)).setter(GetLinksRequest.setter(Builder::siteId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("siteId").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(GetLinksRequest.getter(GetLinksRequest::type)).setter(GetLinksRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("type").build()}).build();
    private static final SdkField<String> PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Provider").getter(GetLinksRequest.getter(GetLinksRequest::provider)).setter(GetLinksRequest.setter(Builder::provider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("provider").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetLinksRequest.getter(GetLinksRequest::maxResults)).setter(GetLinksRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetLinksRequest.getter(GetLinksRequest::nextToken)).setter(GetLinksRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_NETWORK_ID_FIELD, LINK_IDS_FIELD, SITE_ID_FIELD, TYPE_FIELD, PROVIDER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String globalNetworkId;
    private final List<String> linkIds;
    private final String siteId;
    private final String type;
    private final String provider;
    private final Integer maxResults;
    private final String nextToken;

    private GetLinksRequest(BuilderImpl builder) {
        super(builder);
        this.globalNetworkId = builder.globalNetworkId;
        this.linkIds = builder.linkIds;
        this.siteId = builder.siteId;
        this.type = builder.type;
        this.provider = builder.provider;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String globalNetworkId() {
        return this.globalNetworkId;
    }

    public final boolean hasLinkIds() {
        return this.linkIds != null && !(this.linkIds instanceof SdkAutoConstructList);
    }

    public final List<String> linkIds() {
        return this.linkIds;
    }

    public final String siteId() {
        return this.siteId;
    }

    public final String type() {
        return this.type;
    }

    public final String provider() {
        return this.provider;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.globalNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLinkIds() ? this.linkIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.siteId());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.provider());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLinksRequest)) {
            return false;
        }
        GetLinksRequest other = (GetLinksRequest)((Object)obj);
        return Objects.equals(this.globalNetworkId(), other.globalNetworkId()) && this.hasLinkIds() == other.hasLinkIds() && Objects.equals(this.linkIds(), other.linkIds()) && Objects.equals(this.siteId(), other.siteId()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.provider(), other.provider()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetLinksRequest").add("GlobalNetworkId", (Object)this.globalNetworkId()).add("LinkIds", this.hasLinkIds() ? this.linkIds() : null).add("SiteId", (Object)this.siteId()).add("Type", (Object)this.type()).add("Provider", (Object)this.provider()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlobalNetworkId": {
                return Optional.ofNullable(clazz.cast(this.globalNetworkId()));
            }
            case "LinkIds": {
                return Optional.ofNullable(clazz.cast(this.linkIds()));
            }
            case "SiteId": {
                return Optional.ofNullable(clazz.cast(this.siteId()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "Provider": {
                return Optional.ofNullable(clazz.cast(this.provider()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLinksRequest, T> g) {
        return obj -> g.apply((GetLinksRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkManagerRequest.BuilderImpl
    implements Builder {
        private String globalNetworkId;
        private List<String> linkIds = DefaultSdkAutoConstructList.getInstance();
        private String siteId;
        private String type;
        private String provider;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLinksRequest model) {
            super(model);
            this.globalNetworkId(model.globalNetworkId);
            this.linkIds(model.linkIds);
            this.siteId(model.siteId);
            this.type(model.type);
            this.provider(model.provider);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getGlobalNetworkId() {
            return this.globalNetworkId;
        }

        public final void setGlobalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
        }

        @Override
        @Transient
        public final Builder globalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        public final Collection<String> getLinkIds() {
            if (this.linkIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.linkIds;
        }

        public final void setLinkIds(Collection<String> linkIds) {
            this.linkIds = LinkIdListCopier.copy(linkIds);
        }

        @Override
        @Transient
        public final Builder linkIds(Collection<String> linkIds) {
            this.linkIds = LinkIdListCopier.copy(linkIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder linkIds(String ... linkIds) {
            this.linkIds(Arrays.asList(linkIds));
            return this;
        }

        public final String getSiteId() {
            return this.siteId;
        }

        public final void setSiteId(String siteId) {
            this.siteId = siteId;
        }

        @Override
        @Transient
        public final Builder siteId(String siteId) {
            this.siteId = siteId;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getProvider() {
            return this.provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        @Transient
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetLinksRequest build() {
            return new GetLinksRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NetworkManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLinksRequest> {
        public Builder globalNetworkId(String var1);

        public Builder linkIds(Collection<String> var1);

        public Builder linkIds(String ... var1);

        public Builder siteId(String var1);

        public Builder type(String var1);

        public Builder provider(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

