/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerAsyncClient;
import software.amazon.awssdk.services.networkmanager.model.GetSitesRequest;
import software.amazon.awssdk.services.networkmanager.model.GetSitesResponse;
import software.amazon.awssdk.services.networkmanager.model.Site;

public class GetSitesPublisher
implements SdkPublisher<GetSitesResponse> {
    private final NetworkManagerAsyncClient client;
    private final GetSitesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetSitesPublisher(NetworkManagerAsyncClient client, GetSitesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetSitesPublisher(NetworkManagerAsyncClient client, GetSitesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetSitesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetSitesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Site> sites() {
        Function<GetSitesResponse, Iterator> getIterator = response -> {
            if (response != null && response.sites() != null) {
                return response.sites().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetSitesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetSitesResponseFetcher
    implements AsyncPageFetcher<GetSitesResponse> {
        private GetSitesResponseFetcher() {
        }

        public boolean hasNextPage(GetSitesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetSitesResponse> nextPage(GetSitesResponse previousPage) {
            if (previousPage == null) {
                return GetSitesPublisher.this.client.getSites(GetSitesPublisher.this.firstRequest);
            }
            return GetSitesPublisher.this.client.getSites((GetSitesRequest)((Object)GetSitesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

