/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLinkAssociationsResponse extends NetworkManagerResponse implements
        ToCopyableBuilder<GetLinkAssociationsResponse.Builder, GetLinkAssociationsResponse> {
    private static final SdkField<List<LinkAssociation>> LINK_ASSOCIATIONS_FIELD = SdkField
            .<List<LinkAssociation>> builder(MarshallingType.LIST)
            .memberName("LinkAssociations")
            .getter(getter(GetLinkAssociationsResponse::linkAssociations))
            .setter(setter(Builder::linkAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkAssociations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LinkAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(LinkAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetLinkAssociationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINK_ASSOCIATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<LinkAssociation> linkAssociations;

    private final String nextToken;

    private GetLinkAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.linkAssociations = builder.linkAssociations;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the LinkAssociations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasLinkAssociations() {
        return linkAssociations != null && !(linkAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The link associations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLinkAssociations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The link associations.
     */
    public final List<LinkAssociation> linkAssociations() {
        return linkAssociations;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLinkAssociations() ? linkAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLinkAssociationsResponse)) {
            return false;
        }
        GetLinkAssociationsResponse other = (GetLinkAssociationsResponse) obj;
        return hasLinkAssociations() == other.hasLinkAssociations()
                && Objects.equals(linkAssociations(), other.linkAssociations()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLinkAssociationsResponse")
                .add("LinkAssociations", hasLinkAssociations() ? linkAssociations() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LinkAssociations":
            return Optional.ofNullable(clazz.cast(linkAssociations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLinkAssociationsResponse, T> g) {
        return obj -> g.apply((GetLinkAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetLinkAssociationsResponse> {
        /**
         * <p>
         * The link associations.
         * </p>
         * 
         * @param linkAssociations
         *        The link associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkAssociations(Collection<LinkAssociation> linkAssociations);

        /**
         * <p>
         * The link associations.
         * </p>
         * 
         * @param linkAssociations
         *        The link associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkAssociations(LinkAssociation... linkAssociations);

        /**
         * <p>
         * The link associations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LinkAssociation>.Builder} avoiding the need
         * to create one manually via {@link List<LinkAssociation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LinkAssociation>.Builder#build()} is called immediately and
         * its result is passed to {@link #linkAssociations(List<LinkAssociation>)}.
         * 
         * @param linkAssociations
         *        a consumer that will call methods on {@link List<LinkAssociation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #linkAssociations(List<LinkAssociation>)
         */
        Builder linkAssociations(Consumer<LinkAssociation.Builder>... linkAssociations);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends NetworkManagerResponse.BuilderImpl implements Builder {
        private List<LinkAssociation> linkAssociations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLinkAssociationsResponse model) {
            super(model);
            linkAssociations(model.linkAssociations);
            nextToken(model.nextToken);
        }

        public final Collection<LinkAssociation.Builder> getLinkAssociations() {
            if (linkAssociations instanceof SdkAutoConstructList) {
                return null;
            }
            return linkAssociations != null ? linkAssociations.stream().map(LinkAssociation::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder linkAssociations(Collection<LinkAssociation> linkAssociations) {
            this.linkAssociations = LinkAssociationListCopier.copy(linkAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkAssociations(LinkAssociation... linkAssociations) {
            linkAssociations(Arrays.asList(linkAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkAssociations(Consumer<LinkAssociation.Builder>... linkAssociations) {
            linkAssociations(Stream.of(linkAssociations).map(c -> LinkAssociation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLinkAssociations(Collection<LinkAssociation.BuilderImpl> linkAssociations) {
            this.linkAssociations = LinkAssociationListCopier.copyFromBuilder(linkAssociations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetLinkAssociationsResponse build() {
            return new GetLinkAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
