/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerResponse;
import software.amazon.awssdk.services.networkmanager.model.TransitGatewayConnectPeerAssociation;
import software.amazon.awssdk.services.networkmanager.model.TransitGatewayConnectPeerAssociationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTransitGatewayConnectPeerAssociationsResponse
extends NetworkManagerResponse
implements ToCopyableBuilder<Builder, GetTransitGatewayConnectPeerAssociationsResponse> {
    private static final SdkField<List<TransitGatewayConnectPeerAssociation>> TRANSIT_GATEWAY_CONNECT_PEER_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TransitGatewayConnectPeerAssociations").getter(GetTransitGatewayConnectPeerAssociationsResponse.getter(GetTransitGatewayConnectPeerAssociationsResponse::transitGatewayConnectPeerAssociations)).setter(GetTransitGatewayConnectPeerAssociationsResponse.setter(Builder::transitGatewayConnectPeerAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayConnectPeerAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransitGatewayConnectPeerAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetTransitGatewayConnectPeerAssociationsResponse.getter(GetTransitGatewayConnectPeerAssociationsResponse::nextToken)).setter(GetTransitGatewayConnectPeerAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_CONNECT_PEER_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<TransitGatewayConnectPeerAssociation> transitGatewayConnectPeerAssociations;
    private final String nextToken;

    private GetTransitGatewayConnectPeerAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.transitGatewayConnectPeerAssociations = builder.transitGatewayConnectPeerAssociations;
        this.nextToken = builder.nextToken;
    }

    public boolean hasTransitGatewayConnectPeerAssociations() {
        return this.transitGatewayConnectPeerAssociations != null && !(this.transitGatewayConnectPeerAssociations instanceof SdkAutoConstructList);
    }

    public List<TransitGatewayConnectPeerAssociation> transitGatewayConnectPeerAssociations() {
        return this.transitGatewayConnectPeerAssociations;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransitGatewayConnectPeerAssociations() ? this.transitGatewayConnectPeerAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTransitGatewayConnectPeerAssociationsResponse)) {
            return false;
        }
        GetTransitGatewayConnectPeerAssociationsResponse other = (GetTransitGatewayConnectPeerAssociationsResponse)((Object)obj);
        return this.hasTransitGatewayConnectPeerAssociations() == other.hasTransitGatewayConnectPeerAssociations() && Objects.equals(this.transitGatewayConnectPeerAssociations(), other.transitGatewayConnectPeerAssociations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetTransitGatewayConnectPeerAssociationsResponse").add("TransitGatewayConnectPeerAssociations", this.hasTransitGatewayConnectPeerAssociations() ? this.transitGatewayConnectPeerAssociations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayConnectPeerAssociations": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayConnectPeerAssociations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTransitGatewayConnectPeerAssociationsResponse, T> g) {
        return obj -> g.apply((GetTransitGatewayConnectPeerAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkManagerResponse.BuilderImpl
    implements Builder {
        private List<TransitGatewayConnectPeerAssociation> transitGatewayConnectPeerAssociations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTransitGatewayConnectPeerAssociationsResponse model) {
            super(model);
            this.transitGatewayConnectPeerAssociations(model.transitGatewayConnectPeerAssociations);
            this.nextToken(model.nextToken);
        }

        public final Collection<TransitGatewayConnectPeerAssociation.Builder> getTransitGatewayConnectPeerAssociations() {
            if (this.transitGatewayConnectPeerAssociations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.transitGatewayConnectPeerAssociations != null ? (Collection)this.transitGatewayConnectPeerAssociations.stream().map(TransitGatewayConnectPeerAssociation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder transitGatewayConnectPeerAssociations(Collection<TransitGatewayConnectPeerAssociation> transitGatewayConnectPeerAssociations) {
            this.transitGatewayConnectPeerAssociations = TransitGatewayConnectPeerAssociationListCopier.copy(transitGatewayConnectPeerAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayConnectPeerAssociations(TransitGatewayConnectPeerAssociation ... transitGatewayConnectPeerAssociations) {
            this.transitGatewayConnectPeerAssociations(Arrays.asList(transitGatewayConnectPeerAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayConnectPeerAssociations(Consumer<TransitGatewayConnectPeerAssociation.Builder> ... transitGatewayConnectPeerAssociations) {
            this.transitGatewayConnectPeerAssociations(Stream.of(transitGatewayConnectPeerAssociations).map(c -> (TransitGatewayConnectPeerAssociation)((TransitGatewayConnectPeerAssociation.Builder)TransitGatewayConnectPeerAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTransitGatewayConnectPeerAssociations(Collection<TransitGatewayConnectPeerAssociation.BuilderImpl> transitGatewayConnectPeerAssociations) {
            this.transitGatewayConnectPeerAssociations = TransitGatewayConnectPeerAssociationListCopier.copyFromBuilder(transitGatewayConnectPeerAssociations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetTransitGatewayConnectPeerAssociationsResponse build() {
            return new GetTransitGatewayConnectPeerAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NetworkManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTransitGatewayConnectPeerAssociationsResponse> {
        public Builder transitGatewayConnectPeerAssociations(Collection<TransitGatewayConnectPeerAssociation> var1);

        public Builder transitGatewayConnectPeerAssociations(TransitGatewayConnectPeerAssociation ... var1);

        public Builder transitGatewayConnectPeerAssociations(Consumer<TransitGatewayConnectPeerAssociation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

