/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.Link;
import software.amazon.awssdk.services.networkmanager.model.LinkListCopier;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLinksResponse
extends NetworkManagerResponse
implements ToCopyableBuilder<Builder, GetLinksResponse> {
    private static final SdkField<List<Link>> LINKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Links").getter(GetLinksResponse.getter(GetLinksResponse::links)).setter(GetLinksResponse.setter(Builder::links)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Links").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Link::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetLinksResponse.getter(GetLinksResponse::nextToken)).setter(GetLinksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINKS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Link> links;
    private final String nextToken;

    private GetLinksResponse(BuilderImpl builder) {
        super(builder);
        this.links = builder.links;
        this.nextToken = builder.nextToken;
    }

    public boolean hasLinks() {
        return this.links != null && !(this.links instanceof SdkAutoConstructList);
    }

    public List<Link> links() {
        return this.links;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.links());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLinksResponse)) {
            return false;
        }
        GetLinksResponse other = (GetLinksResponse)((Object)obj);
        return Objects.equals(this.links(), other.links()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetLinksResponse").add("Links", this.links()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Links": {
                return Optional.ofNullable(clazz.cast(this.links()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLinksResponse, T> g) {
        return obj -> g.apply((GetLinksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkManagerResponse.BuilderImpl
    implements Builder {
        private List<Link> links = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLinksResponse model) {
            super(model);
            this.links(model.links);
            this.nextToken(model.nextToken);
        }

        public final Collection<Link.Builder> getLinks() {
            return this.links != null ? (Collection)this.links.stream().map(Link::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder links(Collection<Link> links) {
            this.links = LinkListCopier.copy(links);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder links(Link ... links) {
            this.links(Arrays.asList(links));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder links(Consumer<Link.Builder> ... links) {
            this.links(Stream.of(links).map(c -> (Link)((Link.Builder)Link.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLinks(Collection<Link.BuilderImpl> links) {
            this.links = LinkListCopier.copyFromBuilder(links);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetLinksResponse build() {
            return new GetLinksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NetworkManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLinksResponse> {
        public Builder links(Collection<Link> var1);

        public Builder links(Link ... var1);

        public Builder links(Consumer<Link.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

