/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Bandwidth
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Bandwidth> {
    private static final SdkField<Integer> UPLOAD_SPEED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("UploadSpeed").getter(Bandwidth.getter(Bandwidth::uploadSpeed)).setter(Bandwidth.setter(Builder::uploadSpeed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadSpeed").build()}).build();
    private static final SdkField<Integer> DOWNLOAD_SPEED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DownloadSpeed").getter(Bandwidth.getter(Bandwidth::downloadSpeed)).setter(Bandwidth.setter(Builder::downloadSpeed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DownloadSpeed").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPLOAD_SPEED_FIELD, DOWNLOAD_SPEED_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer uploadSpeed;
    private final Integer downloadSpeed;

    private Bandwidth(BuilderImpl builder) {
        this.uploadSpeed = builder.uploadSpeed;
        this.downloadSpeed = builder.downloadSpeed;
    }

    public Integer uploadSpeed() {
        return this.uploadSpeed;
    }

    public Integer downloadSpeed() {
        return this.downloadSpeed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadSpeed());
        hashCode = 31 * hashCode + Objects.hashCode(this.downloadSpeed());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Bandwidth)) {
            return false;
        }
        Bandwidth other = (Bandwidth)obj;
        return Objects.equals(this.uploadSpeed(), other.uploadSpeed()) && Objects.equals(this.downloadSpeed(), other.downloadSpeed());
    }

    public String toString() {
        return ToString.builder((String)"Bandwidth").add("UploadSpeed", (Object)this.uploadSpeed()).add("DownloadSpeed", (Object)this.downloadSpeed()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UploadSpeed": {
                return Optional.ofNullable(clazz.cast(this.uploadSpeed()));
            }
            case "DownloadSpeed": {
                return Optional.ofNullable(clazz.cast(this.downloadSpeed()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Bandwidth, T> g) {
        return obj -> g.apply((Bandwidth)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer uploadSpeed;
        private Integer downloadSpeed;

        private BuilderImpl() {
        }

        private BuilderImpl(Bandwidth model) {
            this.uploadSpeed(model.uploadSpeed);
            this.downloadSpeed(model.downloadSpeed);
        }

        public final Integer getUploadSpeed() {
            return this.uploadSpeed;
        }

        @Override
        public final Builder uploadSpeed(Integer uploadSpeed) {
            this.uploadSpeed = uploadSpeed;
            return this;
        }

        public final void setUploadSpeed(Integer uploadSpeed) {
            this.uploadSpeed = uploadSpeed;
        }

        public final Integer getDownloadSpeed() {
            return this.downloadSpeed;
        }

        @Override
        public final Builder downloadSpeed(Integer downloadSpeed) {
            this.downloadSpeed = downloadSpeed;
            return this;
        }

        public final void setDownloadSpeed(Integer downloadSpeed) {
            this.downloadSpeed = downloadSpeed;
        }

        public Bandwidth build() {
            return new Bandwidth(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Bandwidth> {
        public Builder uploadSpeed(Integer var1);

        public Builder downloadSpeed(Integer var1);
    }
}

