/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallAsyncClient;
import software.amazon.awssdk.services.networkfirewall.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkfirewall.model.AnalysisTypeReportResult;
import software.amazon.awssdk.services.networkfirewall.model.GetAnalysisReportResultsRequest;
import software.amazon.awssdk.services.networkfirewall.model.GetAnalysisReportResultsResponse;

public class GetAnalysisReportResultsPublisher
implements SdkPublisher<GetAnalysisReportResultsResponse> {
    private final NetworkFirewallAsyncClient client;
    private final GetAnalysisReportResultsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetAnalysisReportResultsPublisher(NetworkFirewallAsyncClient client, GetAnalysisReportResultsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetAnalysisReportResultsPublisher(NetworkFirewallAsyncClient client, GetAnalysisReportResultsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetAnalysisReportResultsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetAnalysisReportResultsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AnalysisTypeReportResult> analysisReportResults() {
        Function<GetAnalysisReportResultsResponse, Iterator> getIterator = response -> {
            if (response != null && response.analysisReportResults() != null) {
                return response.analysisReportResults().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetAnalysisReportResultsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetAnalysisReportResultsResponseFetcher
    implements AsyncPageFetcher<GetAnalysisReportResultsResponse> {
        private GetAnalysisReportResultsResponseFetcher() {
        }

        public boolean hasNextPage(GetAnalysisReportResultsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetAnalysisReportResultsResponse> nextPage(GetAnalysisReportResultsResponse previousPage) {
            if (previousPage == null) {
                return GetAnalysisReportResultsPublisher.this.client.getAnalysisReportResults(GetAnalysisReportResultsPublisher.this.firstRequest);
            }
            return GetAnalysisReportResultsPublisher.this.client.getAnalysisReportResults((GetAnalysisReportResultsRequest)((Object)GetAnalysisReportResultsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

