/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.ListenerPropertiesRequestCopier;
import software.amazon.awssdk.services.networkfirewall.model.ListenerPropertyRequest;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.Tag;
import software.amazon.awssdk.services.networkfirewall.model.TagListCopier;
import software.amazon.awssdk.services.networkfirewall.model.TlsInterceptPropertiesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProxyRequest
extends NetworkFirewallRequest
implements ToCopyableBuilder<Builder, CreateProxyRequest> {
    private static final SdkField<String> PROXY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxyName").getter(CreateProxyRequest.getter(CreateProxyRequest::proxyName)).setter(CreateProxyRequest.setter(Builder::proxyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyName").build()}).build();
    private static final SdkField<String> NAT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NatGatewayId").getter(CreateProxyRequest.getter(CreateProxyRequest::natGatewayId)).setter(CreateProxyRequest.setter(Builder::natGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGatewayId").build()}).build();
    private static final SdkField<String> PROXY_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxyConfigurationName").getter(CreateProxyRequest.getter(CreateProxyRequest::proxyConfigurationName)).setter(CreateProxyRequest.setter(Builder::proxyConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyConfigurationName").build()}).build();
    private static final SdkField<String> PROXY_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxyConfigurationArn").getter(CreateProxyRequest.getter(CreateProxyRequest::proxyConfigurationArn)).setter(CreateProxyRequest.setter(Builder::proxyConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyConfigurationArn").build()}).build();
    private static final SdkField<List<ListenerPropertyRequest>> LISTENER_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ListenerProperties").getter(CreateProxyRequest.getter(CreateProxyRequest::listenerProperties)).setter(CreateProxyRequest.setter(Builder::listenerProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListenerProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListenerPropertyRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TlsInterceptPropertiesRequest> TLS_INTERCEPT_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TlsInterceptProperties").getter(CreateProxyRequest.getter(CreateProxyRequest::tlsInterceptProperties)).setter(CreateProxyRequest.setter(Builder::tlsInterceptProperties)).constructor(TlsInterceptPropertiesRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TlsInterceptProperties").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateProxyRequest.getter(CreateProxyRequest::tags)).setter(CreateProxyRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROXY_NAME_FIELD, NAT_GATEWAY_ID_FIELD, PROXY_CONFIGURATION_NAME_FIELD, PROXY_CONFIGURATION_ARN_FIELD, LISTENER_PROPERTIES_FIELD, TLS_INTERCEPT_PROPERTIES_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateProxyRequest.memberNameToFieldInitializer();
    private final String proxyName;
    private final String natGatewayId;
    private final String proxyConfigurationName;
    private final String proxyConfigurationArn;
    private final List<ListenerPropertyRequest> listenerProperties;
    private final TlsInterceptPropertiesRequest tlsInterceptProperties;
    private final List<Tag> tags;

    private CreateProxyRequest(BuilderImpl builder) {
        super(builder);
        this.proxyName = builder.proxyName;
        this.natGatewayId = builder.natGatewayId;
        this.proxyConfigurationName = builder.proxyConfigurationName;
        this.proxyConfigurationArn = builder.proxyConfigurationArn;
        this.listenerProperties = builder.listenerProperties;
        this.tlsInterceptProperties = builder.tlsInterceptProperties;
        this.tags = builder.tags;
    }

    public final String proxyName() {
        return this.proxyName;
    }

    public final String natGatewayId() {
        return this.natGatewayId;
    }

    public final String proxyConfigurationName() {
        return this.proxyConfigurationName;
    }

    public final String proxyConfigurationArn() {
        return this.proxyConfigurationArn;
    }

    public final boolean hasListenerProperties() {
        return this.listenerProperties != null && !(this.listenerProperties instanceof SdkAutoConstructList);
    }

    public final List<ListenerPropertyRequest> listenerProperties() {
        return this.listenerProperties;
    }

    public final TlsInterceptPropertiesRequest tlsInterceptProperties() {
        return this.tlsInterceptProperties;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.natGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasListenerProperties() ? this.listenerProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tlsInterceptProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProxyRequest)) {
            return false;
        }
        CreateProxyRequest other = (CreateProxyRequest)((Object)obj);
        return Objects.equals(this.proxyName(), other.proxyName()) && Objects.equals(this.natGatewayId(), other.natGatewayId()) && Objects.equals(this.proxyConfigurationName(), other.proxyConfigurationName()) && Objects.equals(this.proxyConfigurationArn(), other.proxyConfigurationArn()) && this.hasListenerProperties() == other.hasListenerProperties() && Objects.equals(this.listenerProperties(), other.listenerProperties()) && Objects.equals(this.tlsInterceptProperties(), other.tlsInterceptProperties()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateProxyRequest").add("ProxyName", (Object)this.proxyName()).add("NatGatewayId", (Object)this.natGatewayId()).add("ProxyConfigurationName", (Object)this.proxyConfigurationName()).add("ProxyConfigurationArn", (Object)this.proxyConfigurationArn()).add("ListenerProperties", this.hasListenerProperties() ? this.listenerProperties() : null).add("TlsInterceptProperties", (Object)this.tlsInterceptProperties()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProxyName": {
                return Optional.ofNullable(clazz.cast(this.proxyName()));
            }
            case "NatGatewayId": {
                return Optional.ofNullable(clazz.cast(this.natGatewayId()));
            }
            case "ProxyConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.proxyConfigurationName()));
            }
            case "ProxyConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.proxyConfigurationArn()));
            }
            case "ListenerProperties": {
                return Optional.ofNullable(clazz.cast(this.listenerProperties()));
            }
            case "TlsInterceptProperties": {
                return Optional.ofNullable(clazz.cast(this.tlsInterceptProperties()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProxyName", PROXY_NAME_FIELD);
        map.put("NatGatewayId", NAT_GATEWAY_ID_FIELD);
        map.put("ProxyConfigurationName", PROXY_CONFIGURATION_NAME_FIELD);
        map.put("ProxyConfigurationArn", PROXY_CONFIGURATION_ARN_FIELD);
        map.put("ListenerProperties", LISTENER_PROPERTIES_FIELD);
        map.put("TlsInterceptProperties", TLS_INTERCEPT_PROPERTIES_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProxyRequest, T> g) {
        return obj -> g.apply((CreateProxyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallRequest.BuilderImpl
    implements Builder {
        private String proxyName;
        private String natGatewayId;
        private String proxyConfigurationName;
        private String proxyConfigurationArn;
        private List<ListenerPropertyRequest> listenerProperties = DefaultSdkAutoConstructList.getInstance();
        private TlsInterceptPropertiesRequest tlsInterceptProperties;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProxyRequest model) {
            super(model);
            this.proxyName(model.proxyName);
            this.natGatewayId(model.natGatewayId);
            this.proxyConfigurationName(model.proxyConfigurationName);
            this.proxyConfigurationArn(model.proxyConfigurationArn);
            this.listenerProperties(model.listenerProperties);
            this.tlsInterceptProperties(model.tlsInterceptProperties);
            this.tags(model.tags);
        }

        public final String getProxyName() {
            return this.proxyName;
        }

        public final void setProxyName(String proxyName) {
            this.proxyName = proxyName;
        }

        @Override
        public final Builder proxyName(String proxyName) {
            this.proxyName = proxyName;
            return this;
        }

        public final String getNatGatewayId() {
            return this.natGatewayId;
        }

        public final void setNatGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
        }

        @Override
        public final Builder natGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        public final String getProxyConfigurationName() {
            return this.proxyConfigurationName;
        }

        public final void setProxyConfigurationName(String proxyConfigurationName) {
            this.proxyConfigurationName = proxyConfigurationName;
        }

        @Override
        public final Builder proxyConfigurationName(String proxyConfigurationName) {
            this.proxyConfigurationName = proxyConfigurationName;
            return this;
        }

        public final String getProxyConfigurationArn() {
            return this.proxyConfigurationArn;
        }

        public final void setProxyConfigurationArn(String proxyConfigurationArn) {
            this.proxyConfigurationArn = proxyConfigurationArn;
        }

        @Override
        public final Builder proxyConfigurationArn(String proxyConfigurationArn) {
            this.proxyConfigurationArn = proxyConfigurationArn;
            return this;
        }

        public final List<ListenerPropertyRequest.Builder> getListenerProperties() {
            List<ListenerPropertyRequest.Builder> result = ListenerPropertiesRequestCopier.copyToBuilder(this.listenerProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListenerProperties(Collection<ListenerPropertyRequest.BuilderImpl> listenerProperties) {
            this.listenerProperties = ListenerPropertiesRequestCopier.copyFromBuilder(listenerProperties);
        }

        @Override
        public final Builder listenerProperties(Collection<ListenerPropertyRequest> listenerProperties) {
            this.listenerProperties = ListenerPropertiesRequestCopier.copy(listenerProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listenerProperties(ListenerPropertyRequest ... listenerProperties) {
            this.listenerProperties(Arrays.asList(listenerProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listenerProperties(Consumer<ListenerPropertyRequest.Builder> ... listenerProperties) {
            this.listenerProperties(Stream.of(listenerProperties).map(c -> (ListenerPropertyRequest)((ListenerPropertyRequest.Builder)ListenerPropertyRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TlsInterceptPropertiesRequest.Builder getTlsInterceptProperties() {
            return this.tlsInterceptProperties != null ? this.tlsInterceptProperties.toBuilder() : null;
        }

        public final void setTlsInterceptProperties(TlsInterceptPropertiesRequest.BuilderImpl tlsInterceptProperties) {
            this.tlsInterceptProperties = tlsInterceptProperties != null ? tlsInterceptProperties.build() : null;
        }

        @Override
        public final Builder tlsInterceptProperties(TlsInterceptPropertiesRequest tlsInterceptProperties) {
            this.tlsInterceptProperties = tlsInterceptProperties;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProxyRequest build() {
            return new CreateProxyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkFirewallRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProxyRequest> {
        public Builder proxyName(String var1);

        public Builder natGatewayId(String var1);

        public Builder proxyConfigurationName(String var1);

        public Builder proxyConfigurationArn(String var1);

        public Builder listenerProperties(Collection<ListenerPropertyRequest> var1);

        public Builder listenerProperties(ListenerPropertyRequest ... var1);

        public Builder listenerProperties(Consumer<ListenerPropertyRequest.Builder> ... var1);

        public Builder tlsInterceptProperties(TlsInterceptPropertiesRequest var1);

        default public Builder tlsInterceptProperties(Consumer<TlsInterceptPropertiesRequest.Builder> tlsInterceptProperties) {
            return this.tlsInterceptProperties((TlsInterceptPropertiesRequest)((TlsInterceptPropertiesRequest.Builder)TlsInterceptPropertiesRequest.builder().applyMutation(tlsInterceptProperties)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

