/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallClient;
import software.amazon.awssdk.services.networkfirewall.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkfirewall.model.ListVpcEndpointAssociationsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListVpcEndpointAssociationsResponse;
import software.amazon.awssdk.services.networkfirewall.model.VpcEndpointAssociationMetadata;

public class ListVpcEndpointAssociationsIterable
implements SdkIterable<ListVpcEndpointAssociationsResponse> {
    private final NetworkFirewallClient client;
    private final ListVpcEndpointAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListVpcEndpointAssociationsIterable(NetworkFirewallClient client, ListVpcEndpointAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListVpcEndpointAssociationsResponseFetcher();
    }

    public Iterator<ListVpcEndpointAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<VpcEndpointAssociationMetadata> vpcEndpointAssociations() {
        Function<ListVpcEndpointAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.vpcEndpointAssociations() != null) {
                return response.vpcEndpointAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListVpcEndpointAssociationsResponseFetcher
    implements SyncPageFetcher<ListVpcEndpointAssociationsResponse> {
        private ListVpcEndpointAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListVpcEndpointAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListVpcEndpointAssociationsResponse nextPage(ListVpcEndpointAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListVpcEndpointAssociationsIterable.this.client.listVpcEndpointAssociations(ListVpcEndpointAssociationsIterable.this.firstRequest);
            }
            return ListVpcEndpointAssociationsIterable.this.client.listVpcEndpointAssociations((ListVpcEndpointAssociationsRequest)((Object)ListVpcEndpointAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

