/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.networkfirewall.model.IPSet;
import software.amazon.awssdk.services.networkfirewall.model.IPSetsCopier;
import software.amazon.awssdk.services.networkfirewall.model.PortSet;
import software.amazon.awssdk.services.networkfirewall.model.PortSetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleVariables
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleVariables> {
    private static final SdkField<Map<String, IPSet>> IP_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("IPSets").getter(RuleVariables.getter(RuleVariables::ipSets)).setter(RuleVariables.setter(Builder::ipSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPSets").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IPSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, PortSet>> PORT_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("PortSets").getter(RuleVariables.getter(RuleVariables::portSets)).setter(RuleVariables.setter(Builder::portSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortSets").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PortSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_SETS_FIELD, PORT_SETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RuleVariables.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, IPSet> ipSets;
    private final Map<String, PortSet> portSets;

    private RuleVariables(BuilderImpl builder) {
        this.ipSets = builder.ipSets;
        this.portSets = builder.portSets;
    }

    public final boolean hasIpSets() {
        return this.ipSets != null && !(this.ipSets instanceof SdkAutoConstructMap);
    }

    public final Map<String, IPSet> ipSets() {
        return this.ipSets;
    }

    public final boolean hasPortSets() {
        return this.portSets != null && !(this.portSets instanceof SdkAutoConstructMap);
    }

    public final Map<String, PortSet> portSets() {
        return this.portSets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpSets() ? this.ipSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPortSets() ? this.portSets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleVariables)) {
            return false;
        }
        RuleVariables other = (RuleVariables)obj;
        return this.hasIpSets() == other.hasIpSets() && Objects.equals(this.ipSets(), other.ipSets()) && this.hasPortSets() == other.hasPortSets() && Objects.equals(this.portSets(), other.portSets());
    }

    public final String toString() {
        return ToString.builder((String)"RuleVariables").add("IPSets", this.hasIpSets() ? this.ipSets() : null).add("PortSets", this.hasPortSets() ? this.portSets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IPSets": {
                return Optional.ofNullable(clazz.cast(this.ipSets()));
            }
            case "PortSets": {
                return Optional.ofNullable(clazz.cast(this.portSets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IPSets", IP_SETS_FIELD);
        map.put("PortSets", PORT_SETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleVariables, T> g) {
        return obj -> g.apply((RuleVariables)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, IPSet> ipSets = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, PortSet> portSets = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuleVariables model) {
            this.ipSets(model.ipSets);
            this.portSets(model.portSets);
        }

        public final Map<String, IPSet.Builder> getIpSets() {
            Map<String, IPSet.Builder> result = IPSetsCopier.copyToBuilder(this.ipSets);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setIpSets(Map<String, IPSet.BuilderImpl> ipSets) {
            this.ipSets = IPSetsCopier.copyFromBuilder(ipSets);
        }

        @Override
        public final Builder ipSets(Map<String, IPSet> ipSets) {
            this.ipSets = IPSetsCopier.copy(ipSets);
            return this;
        }

        public final Map<String, PortSet.Builder> getPortSets() {
            Map<String, PortSet.Builder> result = PortSetsCopier.copyToBuilder(this.portSets);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPortSets(Map<String, PortSet.BuilderImpl> portSets) {
            this.portSets = PortSetsCopier.copyFromBuilder(portSets);
        }

        @Override
        public final Builder portSets(Map<String, PortSet> portSets) {
            this.portSets = PortSetsCopier.copy(portSets);
            return this;
        }

        public RuleVariables build() {
            return new RuleVariables(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleVariables> {
        public Builder ipSets(Map<String, IPSet> var1);

        public Builder portSets(Map<String, PortSet> var1);
    }
}

