/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RevocationCheckAction {
    PASS("PASS"),
    DROP("DROP"),
    REJECT("REJECT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RevocationCheckAction> VALUE_MAP;
    private final String value;

    private RevocationCheckAction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RevocationCheckAction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RevocationCheckAction> knownValues() {
        EnumSet<RevocationCheckAction> knownValues = EnumSet.allOf(RevocationCheckAction.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RevocationCheckAction.class, RevocationCheckAction::toString);
    }
}

