/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.FirewallMetadata;
import software.amazon.awssdk.services.networkfirewall.model.FirewallsCopier;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFirewallsResponse
extends NetworkFirewallResponse
implements ToCopyableBuilder<Builder, ListFirewallsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFirewallsResponse.getter(ListFirewallsResponse::nextToken)).setter(ListFirewallsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<FirewallMetadata>> FIREWALLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Firewalls").getter(ListFirewallsResponse.getter(ListFirewallsResponse::firewalls)).setter(ListFirewallsResponse.setter(Builder::firewalls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Firewalls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FirewallMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, FIREWALLS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListFirewallsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<FirewallMetadata> firewalls;

    private ListFirewallsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.firewalls = builder.firewalls;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasFirewalls() {
        return this.firewalls != null && !(this.firewalls instanceof SdkAutoConstructList);
    }

    public final List<FirewallMetadata> firewalls() {
        return this.firewalls;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFirewalls() ? this.firewalls() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFirewallsResponse)) {
            return false;
        }
        ListFirewallsResponse other = (ListFirewallsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasFirewalls() == other.hasFirewalls() && Objects.equals(this.firewalls(), other.firewalls());
    }

    public final String toString() {
        return ToString.builder((String)"ListFirewallsResponse").add("NextToken", (Object)this.nextToken()).add("Firewalls", this.hasFirewalls() ? this.firewalls() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Firewalls": {
                return Optional.ofNullable(clazz.cast(this.firewalls()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Firewalls", FIREWALLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFirewallsResponse, T> g) {
        return obj -> g.apply((ListFirewallsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<FirewallMetadata> firewalls = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFirewallsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.firewalls(model.firewalls);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<FirewallMetadata.Builder> getFirewalls() {
            List<FirewallMetadata.Builder> result = FirewallsCopier.copyToBuilder(this.firewalls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFirewalls(Collection<FirewallMetadata.BuilderImpl> firewalls) {
            this.firewalls = FirewallsCopier.copyFromBuilder(firewalls);
        }

        @Override
        public final Builder firewalls(Collection<FirewallMetadata> firewalls) {
            this.firewalls = FirewallsCopier.copy(firewalls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firewalls(FirewallMetadata ... firewalls) {
            this.firewalls(Arrays.asList(firewalls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firewalls(Consumer<FirewallMetadata.Builder> ... firewalls) {
            this.firewalls(Stream.of(firewalls).map(c -> (FirewallMetadata)((FirewallMetadata.Builder)FirewallMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListFirewallsResponse build() {
            return new ListFirewallsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkFirewallResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFirewallsResponse> {
        public Builder nextToken(String var1);

        public Builder firewalls(Collection<FirewallMetadata> var1);

        public Builder firewalls(FirewallMetadata ... var1);

        public Builder firewalls(Consumer<FirewallMetadata.Builder> ... var1);
    }
}

