/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.AnalysisReportResultsCopier;
import software.amazon.awssdk.services.networkfirewall.model.AnalysisTypeReportResult;
import software.amazon.awssdk.services.networkfirewall.model.EnabledAnalysisType;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAnalysisReportResultsResponse
extends NetworkFirewallResponse
implements ToCopyableBuilder<Builder, GetAnalysisReportResultsResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetAnalysisReportResultsResponse.getter(GetAnalysisReportResultsResponse::status)).setter(GetAnalysisReportResultsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(GetAnalysisReportResultsResponse.getter(GetAnalysisReportResultsResponse::startTime)).setter(GetAnalysisReportResultsResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(GetAnalysisReportResultsResponse.getter(GetAnalysisReportResultsResponse::endTime)).setter(GetAnalysisReportResultsResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<Instant> REPORT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReportTime").getter(GetAnalysisReportResultsResponse.getter(GetAnalysisReportResultsResponse::reportTime)).setter(GetAnalysisReportResultsResponse.setter(Builder::reportTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportTime").build()}).build();
    private static final SdkField<String> ANALYSIS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnalysisType").getter(GetAnalysisReportResultsResponse.getter(GetAnalysisReportResultsResponse::analysisTypeAsString)).setter(GetAnalysisReportResultsResponse.setter(Builder::analysisType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisType").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetAnalysisReportResultsResponse.getter(GetAnalysisReportResultsResponse::nextToken)).setter(GetAnalysisReportResultsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<AnalysisTypeReportResult>> ANALYSIS_REPORT_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AnalysisReportResults").getter(GetAnalysisReportResultsResponse.getter(GetAnalysisReportResultsResponse::analysisReportResults)).setter(GetAnalysisReportResultsResponse.setter(Builder::analysisReportResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisReportResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalysisTypeReportResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, START_TIME_FIELD, END_TIME_FIELD, REPORT_TIME_FIELD, ANALYSIS_TYPE_FIELD, NEXT_TOKEN_FIELD, ANALYSIS_REPORT_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAnalysisReportResultsResponse.memberNameToFieldInitializer();
    private final String status;
    private final Instant startTime;
    private final Instant endTime;
    private final Instant reportTime;
    private final String analysisType;
    private final String nextToken;
    private final List<AnalysisTypeReportResult> analysisReportResults;

    private GetAnalysisReportResultsResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.reportTime = builder.reportTime;
        this.analysisType = builder.analysisType;
        this.nextToken = builder.nextToken;
        this.analysisReportResults = builder.analysisReportResults;
    }

    public final String status() {
        return this.status;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Instant reportTime() {
        return this.reportTime;
    }

    public final EnabledAnalysisType analysisType() {
        return EnabledAnalysisType.fromValue(this.analysisType);
    }

    public final String analysisTypeAsString() {
        return this.analysisType;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasAnalysisReportResults() {
        return this.analysisReportResults != null && !(this.analysisReportResults instanceof SdkAutoConstructList);
    }

    public final List<AnalysisTypeReportResult> analysisReportResults() {
        return this.analysisReportResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnalysisReportResults() ? this.analysisReportResults() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAnalysisReportResultsResponse)) {
            return false;
        }
        GetAnalysisReportResultsResponse other = (GetAnalysisReportResultsResponse)((Object)obj);
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.reportTime(), other.reportTime()) && Objects.equals(this.analysisTypeAsString(), other.analysisTypeAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasAnalysisReportResults() == other.hasAnalysisReportResults() && Objects.equals(this.analysisReportResults(), other.analysisReportResults());
    }

    public final String toString() {
        return ToString.builder((String)"GetAnalysisReportResultsResponse").add("Status", (Object)this.status()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("ReportTime", (Object)this.reportTime()).add("AnalysisType", (Object)this.analysisTypeAsString()).add("NextToken", (Object)this.nextToken()).add("AnalysisReportResults", this.hasAnalysisReportResults() ? this.analysisReportResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "ReportTime": {
                return Optional.ofNullable(clazz.cast(this.reportTime()));
            }
            case "AnalysisType": {
                return Optional.ofNullable(clazz.cast(this.analysisTypeAsString()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "AnalysisReportResults": {
                return Optional.ofNullable(clazz.cast(this.analysisReportResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Status", STATUS_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("ReportTime", REPORT_TIME_FIELD);
        map.put("AnalysisType", ANALYSIS_TYPE_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("AnalysisReportResults", ANALYSIS_REPORT_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAnalysisReportResultsResponse, T> g) {
        return obj -> g.apply((GetAnalysisReportResultsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallResponse.BuilderImpl
    implements Builder {
        private String status;
        private Instant startTime;
        private Instant endTime;
        private Instant reportTime;
        private String analysisType;
        private String nextToken;
        private List<AnalysisTypeReportResult> analysisReportResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAnalysisReportResultsResponse model) {
            super(model);
            this.status(model.status);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.reportTime(model.reportTime);
            this.analysisType(model.analysisType);
            this.nextToken(model.nextToken);
            this.analysisReportResults(model.analysisReportResults);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Instant getReportTime() {
            return this.reportTime;
        }

        public final void setReportTime(Instant reportTime) {
            this.reportTime = reportTime;
        }

        @Override
        public final Builder reportTime(Instant reportTime) {
            this.reportTime = reportTime;
            return this;
        }

        public final String getAnalysisType() {
            return this.analysisType;
        }

        public final void setAnalysisType(String analysisType) {
            this.analysisType = analysisType;
        }

        @Override
        public final Builder analysisType(String analysisType) {
            this.analysisType = analysisType;
            return this;
        }

        @Override
        public final Builder analysisType(EnabledAnalysisType analysisType) {
            this.analysisType(analysisType == null ? null : analysisType.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<AnalysisTypeReportResult.Builder> getAnalysisReportResults() {
            List<AnalysisTypeReportResult.Builder> result = AnalysisReportResultsCopier.copyToBuilder(this.analysisReportResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnalysisReportResults(Collection<AnalysisTypeReportResult.BuilderImpl> analysisReportResults) {
            this.analysisReportResults = AnalysisReportResultsCopier.copyFromBuilder(analysisReportResults);
        }

        @Override
        public final Builder analysisReportResults(Collection<AnalysisTypeReportResult> analysisReportResults) {
            this.analysisReportResults = AnalysisReportResultsCopier.copy(analysisReportResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisReportResults(AnalysisTypeReportResult ... analysisReportResults) {
            this.analysisReportResults(Arrays.asList(analysisReportResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisReportResults(Consumer<AnalysisTypeReportResult.Builder> ... analysisReportResults) {
            this.analysisReportResults(Stream.of(analysisReportResults).map(c -> (AnalysisTypeReportResult)((AnalysisTypeReportResult.Builder)AnalysisTypeReportResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetAnalysisReportResultsResponse build() {
            return new GetAnalysisReportResultsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkFirewallResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAnalysisReportResultsResponse> {
        public Builder status(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder reportTime(Instant var1);

        public Builder analysisType(String var1);

        public Builder analysisType(EnabledAnalysisType var1);

        public Builder nextToken(String var1);

        public Builder analysisReportResults(Collection<AnalysisTypeReportResult> var1);

        public Builder analysisReportResults(AnalysisTypeReportResult ... var1);

        public Builder analysisReportResults(Consumer<AnalysisTypeReportResult.Builder> ... var1);
    }
}

