/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkfirewall.model.Firewall;
import software.amazon.awssdk.services.networkfirewall.model.FirewallStatus;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFirewallResponse
extends NetworkFirewallResponse
implements ToCopyableBuilder<Builder, DescribeFirewallResponse> {
    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateToken").getter(DescribeFirewallResponse.getter(DescribeFirewallResponse::updateToken)).setter(DescribeFirewallResponse.setter(Builder::updateToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build()}).build();
    private static final SdkField<Firewall> FIREWALL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Firewall").getter(DescribeFirewallResponse.getter(DescribeFirewallResponse::firewall)).setter(DescribeFirewallResponse.setter(Builder::firewall)).constructor(Firewall::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Firewall").build()}).build();
    private static final SdkField<FirewallStatus> FIREWALL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FirewallStatus").getter(DescribeFirewallResponse.getter(DescribeFirewallResponse::firewallStatus)).setter(DescribeFirewallResponse.setter(Builder::firewallStatus)).constructor(FirewallStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATE_TOKEN_FIELD, FIREWALL_FIELD, FIREWALL_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeFirewallResponse.memberNameToFieldInitializer();
    private final String updateToken;
    private final Firewall firewall;
    private final FirewallStatus firewallStatus;

    private DescribeFirewallResponse(BuilderImpl builder) {
        super(builder);
        this.updateToken = builder.updateToken;
        this.firewall = builder.firewall;
        this.firewallStatus = builder.firewallStatus;
    }

    public final String updateToken() {
        return this.updateToken;
    }

    public final Firewall firewall() {
        return this.firewall;
    }

    public final FirewallStatus firewallStatus() {
        return this.firewallStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.updateToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewall());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFirewallResponse)) {
            return false;
        }
        DescribeFirewallResponse other = (DescribeFirewallResponse)((Object)obj);
        return Objects.equals(this.updateToken(), other.updateToken()) && Objects.equals(this.firewall(), other.firewall()) && Objects.equals(this.firewallStatus(), other.firewallStatus());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFirewallResponse").add("UpdateToken", (Object)this.updateToken()).add("Firewall", (Object)this.firewall()).add("FirewallStatus", (Object)this.firewallStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UpdateToken": {
                return Optional.ofNullable(clazz.cast(this.updateToken()));
            }
            case "Firewall": {
                return Optional.ofNullable(clazz.cast(this.firewall()));
            }
            case "FirewallStatus": {
                return Optional.ofNullable(clazz.cast(this.firewallStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UpdateToken", UPDATE_TOKEN_FIELD);
        map.put("Firewall", FIREWALL_FIELD);
        map.put("FirewallStatus", FIREWALL_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFirewallResponse, T> g) {
        return obj -> g.apply((DescribeFirewallResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallResponse.BuilderImpl
    implements Builder {
        private String updateToken;
        private Firewall firewall;
        private FirewallStatus firewallStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFirewallResponse model) {
            super(model);
            this.updateToken(model.updateToken);
            this.firewall(model.firewall);
            this.firewallStatus(model.firewallStatus);
        }

        public final String getUpdateToken() {
            return this.updateToken;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        public final Firewall.Builder getFirewall() {
            return this.firewall != null ? this.firewall.toBuilder() : null;
        }

        public final void setFirewall(Firewall.BuilderImpl firewall) {
            this.firewall = firewall != null ? firewall.build() : null;
        }

        @Override
        public final Builder firewall(Firewall firewall) {
            this.firewall = firewall;
            return this;
        }

        public final FirewallStatus.Builder getFirewallStatus() {
            return this.firewallStatus != null ? this.firewallStatus.toBuilder() : null;
        }

        public final void setFirewallStatus(FirewallStatus.BuilderImpl firewallStatus) {
            this.firewallStatus = firewallStatus != null ? firewallStatus.build() : null;
        }

        @Override
        public final Builder firewallStatus(FirewallStatus firewallStatus) {
            this.firewallStatus = firewallStatus;
            return this;
        }

        @Override
        public DescribeFirewallResponse build() {
            return new DescribeFirewallResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkFirewallResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFirewallResponse> {
        public Builder updateToken(String var1);

        public Builder firewall(Firewall var1);

        default public Builder firewall(Consumer<Firewall.Builder> firewall) {
            return this.firewall((Firewall)((Firewall.Builder)Firewall.builder().applyMutation(firewall)).build());
        }

        public Builder firewallStatus(FirewallStatus var1);

        default public Builder firewallStatus(Consumer<FirewallStatus.Builder> firewallStatus) {
            return this.firewallStatus((FirewallStatus)((FirewallStatus.Builder)FirewallStatus.builder().applyMutation(firewallStatus)).build());
        }
    }
}

