/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallAsyncClient;
import software.amazon.awssdk.services.networkfirewall.model.FirewallPolicyMetadata;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesResponse;

public class ListFirewallPoliciesPublisher
implements SdkPublisher<ListFirewallPoliciesResponse> {
    private final NetworkFirewallAsyncClient client;
    private final ListFirewallPoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFirewallPoliciesPublisher(NetworkFirewallAsyncClient client, ListFirewallPoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFirewallPoliciesPublisher(NetworkFirewallAsyncClient client, ListFirewallPoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFirewallPoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFirewallPoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FirewallPolicyMetadata> firewallPolicies() {
        Function<ListFirewallPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.firewallPolicies() != null) {
                return response.firewallPolicies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFirewallPoliciesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFirewallPoliciesResponseFetcher
    implements AsyncPageFetcher<ListFirewallPoliciesResponse> {
        private ListFirewallPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListFirewallPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFirewallPoliciesResponse> nextPage(ListFirewallPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListFirewallPoliciesPublisher.this.client.listFirewallPolicies(ListFirewallPoliciesPublisher.this.firstRequest);
            }
            return ListFirewallPoliciesPublisher.this.client.listFirewallPolicies((ListFirewallPoliciesRequest)((Object)ListFirewallPoliciesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

