/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaa.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mwaa.model.ModuleLoggingConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoggingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoggingConfiguration> {
    private static final SdkField<ModuleLoggingConfiguration> DAG_PROCESSING_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DagProcessingLogs").getter(LoggingConfiguration.getter(LoggingConfiguration::dagProcessingLogs)).setter(LoggingConfiguration.setter(Builder::dagProcessingLogs)).constructor(ModuleLoggingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DagProcessingLogs").build()}).build();
    private static final SdkField<ModuleLoggingConfiguration> SCHEDULER_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SchedulerLogs").getter(LoggingConfiguration.getter(LoggingConfiguration::schedulerLogs)).setter(LoggingConfiguration.setter(Builder::schedulerLogs)).constructor(ModuleLoggingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchedulerLogs").build()}).build();
    private static final SdkField<ModuleLoggingConfiguration> TASK_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TaskLogs").getter(LoggingConfiguration.getter(LoggingConfiguration::taskLogs)).setter(LoggingConfiguration.setter(Builder::taskLogs)).constructor(ModuleLoggingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskLogs").build()}).build();
    private static final SdkField<ModuleLoggingConfiguration> WEBSERVER_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WebserverLogs").getter(LoggingConfiguration.getter(LoggingConfiguration::webserverLogs)).setter(LoggingConfiguration.setter(Builder::webserverLogs)).constructor(ModuleLoggingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebserverLogs").build()}).build();
    private static final SdkField<ModuleLoggingConfiguration> WORKER_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WorkerLogs").getter(LoggingConfiguration.getter(LoggingConfiguration::workerLogs)).setter(LoggingConfiguration.setter(Builder::workerLogs)).constructor(ModuleLoggingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerLogs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAG_PROCESSING_LOGS_FIELD, SCHEDULER_LOGS_FIELD, TASK_LOGS_FIELD, WEBSERVER_LOGS_FIELD, WORKER_LOGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final ModuleLoggingConfiguration dagProcessingLogs;
    private final ModuleLoggingConfiguration schedulerLogs;
    private final ModuleLoggingConfiguration taskLogs;
    private final ModuleLoggingConfiguration webserverLogs;
    private final ModuleLoggingConfiguration workerLogs;

    private LoggingConfiguration(BuilderImpl builder) {
        this.dagProcessingLogs = builder.dagProcessingLogs;
        this.schedulerLogs = builder.schedulerLogs;
        this.taskLogs = builder.taskLogs;
        this.webserverLogs = builder.webserverLogs;
        this.workerLogs = builder.workerLogs;
    }

    public ModuleLoggingConfiguration dagProcessingLogs() {
        return this.dagProcessingLogs;
    }

    public ModuleLoggingConfiguration schedulerLogs() {
        return this.schedulerLogs;
    }

    public ModuleLoggingConfiguration taskLogs() {
        return this.taskLogs;
    }

    public ModuleLoggingConfiguration webserverLogs() {
        return this.webserverLogs;
    }

    public ModuleLoggingConfiguration workerLogs() {
        return this.workerLogs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dagProcessingLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedulerLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.webserverLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerLogs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingConfiguration)) {
            return false;
        }
        LoggingConfiguration other = (LoggingConfiguration)obj;
        return Objects.equals(this.dagProcessingLogs(), other.dagProcessingLogs()) && Objects.equals(this.schedulerLogs(), other.schedulerLogs()) && Objects.equals(this.taskLogs(), other.taskLogs()) && Objects.equals(this.webserverLogs(), other.webserverLogs()) && Objects.equals(this.workerLogs(), other.workerLogs());
    }

    public String toString() {
        return ToString.builder((String)"LoggingConfiguration").add("DagProcessingLogs", (Object)this.dagProcessingLogs()).add("SchedulerLogs", (Object)this.schedulerLogs()).add("TaskLogs", (Object)this.taskLogs()).add("WebserverLogs", (Object)this.webserverLogs()).add("WorkerLogs", (Object)this.workerLogs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DagProcessingLogs": {
                return Optional.ofNullable(clazz.cast(this.dagProcessingLogs()));
            }
            case "SchedulerLogs": {
                return Optional.ofNullable(clazz.cast(this.schedulerLogs()));
            }
            case "TaskLogs": {
                return Optional.ofNullable(clazz.cast(this.taskLogs()));
            }
            case "WebserverLogs": {
                return Optional.ofNullable(clazz.cast(this.webserverLogs()));
            }
            case "WorkerLogs": {
                return Optional.ofNullable(clazz.cast(this.workerLogs()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoggingConfiguration, T> g) {
        return obj -> g.apply((LoggingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ModuleLoggingConfiguration dagProcessingLogs;
        private ModuleLoggingConfiguration schedulerLogs;
        private ModuleLoggingConfiguration taskLogs;
        private ModuleLoggingConfiguration webserverLogs;
        private ModuleLoggingConfiguration workerLogs;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingConfiguration model) {
            this.dagProcessingLogs(model.dagProcessingLogs);
            this.schedulerLogs(model.schedulerLogs);
            this.taskLogs(model.taskLogs);
            this.webserverLogs(model.webserverLogs);
            this.workerLogs(model.workerLogs);
        }

        public final ModuleLoggingConfiguration.Builder getDagProcessingLogs() {
            return this.dagProcessingLogs != null ? this.dagProcessingLogs.toBuilder() : null;
        }

        @Override
        public final Builder dagProcessingLogs(ModuleLoggingConfiguration dagProcessingLogs) {
            this.dagProcessingLogs = dagProcessingLogs;
            return this;
        }

        public final void setDagProcessingLogs(ModuleLoggingConfiguration.BuilderImpl dagProcessingLogs) {
            this.dagProcessingLogs = dagProcessingLogs != null ? dagProcessingLogs.build() : null;
        }

        public final ModuleLoggingConfiguration.Builder getSchedulerLogs() {
            return this.schedulerLogs != null ? this.schedulerLogs.toBuilder() : null;
        }

        @Override
        public final Builder schedulerLogs(ModuleLoggingConfiguration schedulerLogs) {
            this.schedulerLogs = schedulerLogs;
            return this;
        }

        public final void setSchedulerLogs(ModuleLoggingConfiguration.BuilderImpl schedulerLogs) {
            this.schedulerLogs = schedulerLogs != null ? schedulerLogs.build() : null;
        }

        public final ModuleLoggingConfiguration.Builder getTaskLogs() {
            return this.taskLogs != null ? this.taskLogs.toBuilder() : null;
        }

        @Override
        public final Builder taskLogs(ModuleLoggingConfiguration taskLogs) {
            this.taskLogs = taskLogs;
            return this;
        }

        public final void setTaskLogs(ModuleLoggingConfiguration.BuilderImpl taskLogs) {
            this.taskLogs = taskLogs != null ? taskLogs.build() : null;
        }

        public final ModuleLoggingConfiguration.Builder getWebserverLogs() {
            return this.webserverLogs != null ? this.webserverLogs.toBuilder() : null;
        }

        @Override
        public final Builder webserverLogs(ModuleLoggingConfiguration webserverLogs) {
            this.webserverLogs = webserverLogs;
            return this;
        }

        public final void setWebserverLogs(ModuleLoggingConfiguration.BuilderImpl webserverLogs) {
            this.webserverLogs = webserverLogs != null ? webserverLogs.build() : null;
        }

        public final ModuleLoggingConfiguration.Builder getWorkerLogs() {
            return this.workerLogs != null ? this.workerLogs.toBuilder() : null;
        }

        @Override
        public final Builder workerLogs(ModuleLoggingConfiguration workerLogs) {
            this.workerLogs = workerLogs;
            return this;
        }

        public final void setWorkerLogs(ModuleLoggingConfiguration.BuilderImpl workerLogs) {
            this.workerLogs = workerLogs != null ? workerLogs.build() : null;
        }

        public LoggingConfiguration build() {
            return new LoggingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoggingConfiguration> {
        public Builder dagProcessingLogs(ModuleLoggingConfiguration var1);

        default public Builder dagProcessingLogs(Consumer<ModuleLoggingConfiguration.Builder> dagProcessingLogs) {
            return this.dagProcessingLogs((ModuleLoggingConfiguration)((ModuleLoggingConfiguration.Builder)ModuleLoggingConfiguration.builder().applyMutation(dagProcessingLogs)).build());
        }

        public Builder schedulerLogs(ModuleLoggingConfiguration var1);

        default public Builder schedulerLogs(Consumer<ModuleLoggingConfiguration.Builder> schedulerLogs) {
            return this.schedulerLogs((ModuleLoggingConfiguration)((ModuleLoggingConfiguration.Builder)ModuleLoggingConfiguration.builder().applyMutation(schedulerLogs)).build());
        }

        public Builder taskLogs(ModuleLoggingConfiguration var1);

        default public Builder taskLogs(Consumer<ModuleLoggingConfiguration.Builder> taskLogs) {
            return this.taskLogs((ModuleLoggingConfiguration)((ModuleLoggingConfiguration.Builder)ModuleLoggingConfiguration.builder().applyMutation(taskLogs)).build());
        }

        public Builder webserverLogs(ModuleLoggingConfiguration var1);

        default public Builder webserverLogs(Consumer<ModuleLoggingConfiguration.Builder> webserverLogs) {
            return this.webserverLogs((ModuleLoggingConfiguration)((ModuleLoggingConfiguration.Builder)ModuleLoggingConfiguration.builder().applyMutation(webserverLogs)).build());
        }

        public Builder workerLogs(ModuleLoggingConfiguration var1);

        default public Builder workerLogs(Consumer<ModuleLoggingConfiguration.Builder> workerLogs) {
            return this.workerLogs((ModuleLoggingConfiguration)((ModuleLoggingConfiguration.Builder)ModuleLoggingConfiguration.builder().applyMutation(workerLogs)).build());
        }
    }
}

