/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mpa.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mpa.model.MpaResponse;
import software.amazon.awssdk.services.mpa.model.PolicyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourcePolicyResponse
extends MpaResponse
implements ToCopyableBuilder<Builder, GetResourcePolicyResponse> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(GetResourcePolicyResponse.getter(GetResourcePolicyResponse::resourceArn)).setter(GetResourcePolicyResponse.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyType").getter(GetResourcePolicyResponse.getter(GetResourcePolicyResponse::policyTypeAsString)).setter(GetResourcePolicyResponse.setter(Builder::policyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()}).build();
    private static final SdkField<String> POLICY_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyVersionArn").getter(GetResourcePolicyResponse.getter(GetResourcePolicyResponse::policyVersionArn)).setter(GetResourcePolicyResponse.setter(Builder::policyVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyVersionArn").build()}).build();
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyName").getter(GetResourcePolicyResponse.getter(GetResourcePolicyResponse::policyName)).setter(GetResourcePolicyResponse.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()}).build();
    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyDocument").getter(GetResourcePolicyResponse.getter(GetResourcePolicyResponse::policyDocument)).setter(GetResourcePolicyResponse.setter(Builder::policyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDocument").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, POLICY_TYPE_FIELD, POLICY_VERSION_ARN_FIELD, POLICY_NAME_FIELD, POLICY_DOCUMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetResourcePolicyResponse.memberNameToFieldInitializer();
    private final String resourceArn;
    private final String policyType;
    private final String policyVersionArn;
    private final String policyName;
    private final String policyDocument;

    private GetResourcePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.policyType = builder.policyType;
        this.policyVersionArn = builder.policyVersionArn;
        this.policyName = builder.policyName;
        this.policyDocument = builder.policyDocument;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final PolicyType policyType() {
        return PolicyType.fromValue(this.policyType);
    }

    public final String policyTypeAsString() {
        return this.policyType;
    }

    public final String policyVersionArn() {
        return this.policyVersionArn;
    }

    public final String policyName() {
        return this.policyName;
    }

    public final String policyDocument() {
        return this.policyDocument;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocument());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourcePolicyResponse)) {
            return false;
        }
        GetResourcePolicyResponse other = (GetResourcePolicyResponse)((Object)obj);
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.policyTypeAsString(), other.policyTypeAsString()) && Objects.equals(this.policyVersionArn(), other.policyVersionArn()) && Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.policyDocument(), other.policyDocument());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourcePolicyResponse").add("ResourceArn", (Object)this.resourceArn()).add("PolicyType", (Object)this.policyTypeAsString()).add("PolicyVersionArn", (Object)this.policyVersionArn()).add("PolicyName", (Object)this.policyName()).add("PolicyDocument", (Object)(this.policyDocument() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "PolicyType": {
                return Optional.ofNullable(clazz.cast(this.policyTypeAsString()));
            }
            case "PolicyVersionArn": {
                return Optional.ofNullable(clazz.cast(this.policyVersionArn()));
            }
            case "PolicyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "PolicyDocument": {
                return Optional.ofNullable(clazz.cast(this.policyDocument()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("PolicyType", POLICY_TYPE_FIELD);
        map.put("PolicyVersionArn", POLICY_VERSION_ARN_FIELD);
        map.put("PolicyName", POLICY_NAME_FIELD);
        map.put("PolicyDocument", POLICY_DOCUMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResourcePolicyResponse, T> g) {
        return obj -> g.apply((GetResourcePolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MpaResponse.BuilderImpl
    implements Builder {
        private String resourceArn;
        private String policyType;
        private String policyVersionArn;
        private String policyName;
        private String policyDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourcePolicyResponse model) {
            super(model);
            this.resourceArn(model.resourceArn);
            this.policyType(model.policyType);
            this.policyVersionArn(model.policyVersionArn);
            this.policyName(model.policyName);
            this.policyDocument(model.policyDocument);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getPolicyType() {
            return this.policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final String getPolicyVersionArn() {
            return this.policyVersionArn;
        }

        public final void setPolicyVersionArn(String policyVersionArn) {
            this.policyVersionArn = policyVersionArn;
        }

        @Override
        public final Builder policyVersionArn(String policyVersionArn) {
            this.policyVersionArn = policyVersionArn;
            return this;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        @Override
        public GetResourcePolicyResponse build() {
            return new GetResourcePolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MpaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourcePolicyResponse> {
        public Builder resourceArn(String var1);

        public Builder policyType(String var1);

        public Builder policyType(PolicyType var1);

        public Builder policyVersionArn(String var1);

        public Builder policyName(String var1);

        public Builder policyDocument(String var1);
    }
}

