/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mpa.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mpa.model.ApprovalStrategy;
import software.amazon.awssdk.services.mpa.model.ApprovalTeamRequestApprover;
import software.amazon.awssdk.services.mpa.model.ApprovalTeamRequestApproversCopier;
import software.amazon.awssdk.services.mpa.model.MpaRequest;
import software.amazon.awssdk.services.mpa.model.PoliciesReferencesCopier;
import software.amazon.awssdk.services.mpa.model.PolicyReference;
import software.amazon.awssdk.services.mpa.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateApprovalTeamRequest
extends MpaRequest
implements ToCopyableBuilder<Builder, CreateApprovalTeamRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateApprovalTeamRequest.getter(CreateApprovalTeamRequest::clientToken)).setter(CreateApprovalTeamRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<ApprovalStrategy> APPROVAL_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApprovalStrategy").getter(CreateApprovalTeamRequest.getter(CreateApprovalTeamRequest::approvalStrategy)).setter(CreateApprovalTeamRequest.setter(Builder::approvalStrategy)).constructor(ApprovalStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalStrategy").build()}).build();
    private static final SdkField<List<ApprovalTeamRequestApprover>> APPROVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Approvers").getter(CreateApprovalTeamRequest.getter(CreateApprovalTeamRequest::approvers)).setter(CreateApprovalTeamRequest.setter(Builder::approvers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Approvers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApprovalTeamRequestApprover::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateApprovalTeamRequest.getter(CreateApprovalTeamRequest::description)).setter(CreateApprovalTeamRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<PolicyReference>> POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Policies").getter(CreateApprovalTeamRequest.getter(CreateApprovalTeamRequest::policies)).setter(CreateApprovalTeamRequest.setter(Builder::policies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PolicyReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateApprovalTeamRequest.getter(CreateApprovalTeamRequest::name)).setter(CreateApprovalTeamRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateApprovalTeamRequest.getter(CreateApprovalTeamRequest::tags)).setter(CreateApprovalTeamRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, APPROVAL_STRATEGY_FIELD, APPROVERS_FIELD, DESCRIPTION_FIELD, POLICIES_FIELD, NAME_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateApprovalTeamRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final ApprovalStrategy approvalStrategy;
    private final List<ApprovalTeamRequestApprover> approvers;
    private final String description;
    private final List<PolicyReference> policies;
    private final String name;
    private final Map<String, String> tags;

    private CreateApprovalTeamRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.approvalStrategy = builder.approvalStrategy;
        this.approvers = builder.approvers;
        this.description = builder.description;
        this.policies = builder.policies;
        this.name = builder.name;
        this.tags = builder.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final ApprovalStrategy approvalStrategy() {
        return this.approvalStrategy;
    }

    public final boolean hasApprovers() {
        return this.approvers != null && !(this.approvers instanceof SdkAutoConstructList);
    }

    public final List<ApprovalTeamRequestApprover> approvers() {
        return this.approvers;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasPolicies() {
        return this.policies != null && !(this.policies instanceof SdkAutoConstructList);
    }

    public final List<PolicyReference> policies() {
        return this.policies;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApprovers() ? this.approvers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicies() ? this.policies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApprovalTeamRequest)) {
            return false;
        }
        CreateApprovalTeamRequest other = (CreateApprovalTeamRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.approvalStrategy(), other.approvalStrategy()) && this.hasApprovers() == other.hasApprovers() && Objects.equals(this.approvers(), other.approvers()) && Objects.equals(this.description(), other.description()) && this.hasPolicies() == other.hasPolicies() && Objects.equals(this.policies(), other.policies()) && Objects.equals(this.name(), other.name()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateApprovalTeamRequest").add("ClientToken", (Object)this.clientToken()).add("ApprovalStrategy", (Object)this.approvalStrategy()).add("Approvers", this.hasApprovers() ? this.approvers() : null).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Policies", this.hasPolicies() ? this.policies() : null).add("Name", (Object)this.name()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "ApprovalStrategy": {
                return Optional.ofNullable(clazz.cast(this.approvalStrategy()));
            }
            case "Approvers": {
                return Optional.ofNullable(clazz.cast(this.approvers()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Policies": {
                return Optional.ofNullable(clazz.cast(this.policies()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("ApprovalStrategy", APPROVAL_STRATEGY_FIELD);
        map.put("Approvers", APPROVERS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Policies", POLICIES_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateApprovalTeamRequest, T> g) {
        return obj -> g.apply((CreateApprovalTeamRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MpaRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private ApprovalStrategy approvalStrategy;
        private List<ApprovalTeamRequestApprover> approvers = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private List<PolicyReference> policies = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApprovalTeamRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.approvalStrategy(model.approvalStrategy);
            this.approvers(model.approvers);
            this.description(model.description);
            this.policies(model.policies);
            this.name(model.name);
            this.tags(model.tags);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final ApprovalStrategy.Builder getApprovalStrategy() {
            return this.approvalStrategy != null ? this.approvalStrategy.toBuilder() : null;
        }

        public final void setApprovalStrategy(ApprovalStrategy.BuilderImpl approvalStrategy) {
            this.approvalStrategy = approvalStrategy != null ? approvalStrategy.build() : null;
        }

        @Override
        public final Builder approvalStrategy(ApprovalStrategy approvalStrategy) {
            this.approvalStrategy = approvalStrategy;
            return this;
        }

        public final List<ApprovalTeamRequestApprover.Builder> getApprovers() {
            List<ApprovalTeamRequestApprover.Builder> result = ApprovalTeamRequestApproversCopier.copyToBuilder(this.approvers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApprovers(Collection<ApprovalTeamRequestApprover.BuilderImpl> approvers) {
            this.approvers = ApprovalTeamRequestApproversCopier.copyFromBuilder(approvers);
        }

        @Override
        public final Builder approvers(Collection<ApprovalTeamRequestApprover> approvers) {
            this.approvers = ApprovalTeamRequestApproversCopier.copy(approvers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvers(ApprovalTeamRequestApprover ... approvers) {
            this.approvers(Arrays.asList(approvers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvers(Consumer<ApprovalTeamRequestApprover.Builder> ... approvers) {
            this.approvers(Stream.of(approvers).map(c -> (ApprovalTeamRequestApprover)((ApprovalTeamRequestApprover.Builder)ApprovalTeamRequestApprover.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<PolicyReference.Builder> getPolicies() {
            List<PolicyReference.Builder> result = PoliciesReferencesCopier.copyToBuilder(this.policies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicies(Collection<PolicyReference.BuilderImpl> policies) {
            this.policies = PoliciesReferencesCopier.copyFromBuilder(policies);
        }

        @Override
        public final Builder policies(Collection<PolicyReference> policies) {
            this.policies = PoliciesReferencesCopier.copy(policies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(PolicyReference ... policies) {
            this.policies(Arrays.asList(policies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(Consumer<PolicyReference.Builder> ... policies) {
            this.policies(Stream.of(policies).map(c -> (PolicyReference)((PolicyReference.Builder)PolicyReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApprovalTeamRequest build() {
            return new CreateApprovalTeamRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MpaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateApprovalTeamRequest> {
        public Builder clientToken(String var1);

        public Builder approvalStrategy(ApprovalStrategy var1);

        default public Builder approvalStrategy(Consumer<ApprovalStrategy.Builder> approvalStrategy) {
            return this.approvalStrategy((ApprovalStrategy)((ApprovalStrategy.Builder)ApprovalStrategy.builder().applyMutation(approvalStrategy)).build());
        }

        public Builder approvers(Collection<ApprovalTeamRequestApprover> var1);

        public Builder approvers(ApprovalTeamRequestApprover ... var1);

        public Builder approvers(Consumer<ApprovalTeamRequestApprover.Builder> ... var1);

        public Builder description(String var1);

        public Builder policies(Collection<PolicyReference> var1);

        public Builder policies(PolicyReference ... var1);

        public Builder policies(Consumer<PolicyReference.Builder> ... var1);

        public Builder name(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

