/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mpa.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mpa.MpaClient;
import software.amazon.awssdk.services.mpa.internal.UserAgentUtils;
import software.amazon.awssdk.services.mpa.model.ListApprovalTeamsRequest;
import software.amazon.awssdk.services.mpa.model.ListApprovalTeamsResponse;
import software.amazon.awssdk.services.mpa.model.ListApprovalTeamsResponseApprovalTeam;

public class ListApprovalTeamsIterable
implements SdkIterable<ListApprovalTeamsResponse> {
    private final MpaClient client;
    private final ListApprovalTeamsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListApprovalTeamsIterable(MpaClient client, ListApprovalTeamsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListApprovalTeamsResponseFetcher();
    }

    public Iterator<ListApprovalTeamsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListApprovalTeamsResponseApprovalTeam> approvalTeams() {
        Function<ListApprovalTeamsResponse, Iterator> getIterator = response -> {
            if (response != null && response.approvalTeams() != null) {
                return response.approvalTeams().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListApprovalTeamsResponseFetcher
    implements SyncPageFetcher<ListApprovalTeamsResponse> {
        private ListApprovalTeamsResponseFetcher() {
        }

        public boolean hasNextPage(ListApprovalTeamsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListApprovalTeamsResponse nextPage(ListApprovalTeamsResponse previousPage) {
            if (previousPage == null) {
                return ListApprovalTeamsIterable.this.client.listApprovalTeams(ListApprovalTeamsIterable.this.firstRequest);
            }
            return ListApprovalTeamsIterable.this.client.listApprovalTeams((ListApprovalTeamsRequest)((Object)ListApprovalTeamsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

