/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mpa.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mpa.model.MpaResponse;
import software.amazon.awssdk.services.mpa.model.PolicyVersionSummary;
import software.amazon.awssdk.services.mpa.model.PolicyVersionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPolicyVersionsResponse
extends MpaResponse
implements ToCopyableBuilder<Builder, ListPolicyVersionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPolicyVersionsResponse.getter(ListPolicyVersionsResponse::nextToken)).setter(ListPolicyVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<PolicyVersionSummary>> POLICY_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PolicyVersions").getter(ListPolicyVersionsResponse.getter(ListPolicyVersionsResponse::policyVersions)).setter(ListPolicyVersionsResponse.setter(Builder::policyVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PolicyVersionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, POLICY_VERSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPolicyVersionsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<PolicyVersionSummary> policyVersions;

    private ListPolicyVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.policyVersions = builder.policyVersions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasPolicyVersions() {
        return this.policyVersions != null && !(this.policyVersions instanceof SdkAutoConstructList);
    }

    public final List<PolicyVersionSummary> policyVersions() {
        return this.policyVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicyVersions() ? this.policyVersions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPolicyVersionsResponse)) {
            return false;
        }
        ListPolicyVersionsResponse other = (ListPolicyVersionsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasPolicyVersions() == other.hasPolicyVersions() && Objects.equals(this.policyVersions(), other.policyVersions());
    }

    public final String toString() {
        return ToString.builder((String)"ListPolicyVersionsResponse").add("NextToken", (Object)this.nextToken()).add("PolicyVersions", this.hasPolicyVersions() ? this.policyVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "PolicyVersions": {
                return Optional.ofNullable(clazz.cast(this.policyVersions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("PolicyVersions", POLICY_VERSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPolicyVersionsResponse, T> g) {
        return obj -> g.apply((ListPolicyVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MpaResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<PolicyVersionSummary> policyVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPolicyVersionsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.policyVersions(model.policyVersions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<PolicyVersionSummary.Builder> getPolicyVersions() {
            List<PolicyVersionSummary.Builder> result = PolicyVersionsCopier.copyToBuilder(this.policyVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicyVersions(Collection<PolicyVersionSummary.BuilderImpl> policyVersions) {
            this.policyVersions = PolicyVersionsCopier.copyFromBuilder(policyVersions);
        }

        @Override
        public final Builder policyVersions(Collection<PolicyVersionSummary> policyVersions) {
            this.policyVersions = PolicyVersionsCopier.copy(policyVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyVersions(PolicyVersionSummary ... policyVersions) {
            this.policyVersions(Arrays.asList(policyVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyVersions(Consumer<PolicyVersionSummary.Builder> ... policyVersions) {
            this.policyVersions(Stream.of(policyVersions).map(c -> (PolicyVersionSummary)((PolicyVersionSummary.Builder)PolicyVersionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPolicyVersionsResponse build() {
            return new ListPolicyVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MpaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPolicyVersionsResponse> {
        public Builder nextToken(String var1);

        public Builder policyVersions(Collection<PolicyVersionSummary> var1);

        public Builder policyVersions(PolicyVersionSummary ... var1);

        public Builder policyVersions(Consumer<PolicyVersionSummary.Builder> ... var1);
    }
}

