/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mpa.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mpa.model.IdentitySourceForList;
import software.amazon.awssdk.services.mpa.model.IdentitySourcesCopier;
import software.amazon.awssdk.services.mpa.model.MpaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIdentitySourcesResponse
extends MpaResponse
implements ToCopyableBuilder<Builder, ListIdentitySourcesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListIdentitySourcesResponse.getter(ListIdentitySourcesResponse::nextToken)).setter(ListIdentitySourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<IdentitySourceForList>> IDENTITY_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IdentitySources").getter(ListIdentitySourcesResponse.getter(ListIdentitySourcesResponse::identitySources)).setter(ListIdentitySourcesResponse.setter(Builder::identitySources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentitySources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IdentitySourceForList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, IDENTITY_SOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListIdentitySourcesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<IdentitySourceForList> identitySources;

    private ListIdentitySourcesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.identitySources = builder.identitySources;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasIdentitySources() {
        return this.identitySources != null && !(this.identitySources instanceof SdkAutoConstructList);
    }

    public final List<IdentitySourceForList> identitySources() {
        return this.identitySources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdentitySources() ? this.identitySources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentitySourcesResponse)) {
            return false;
        }
        ListIdentitySourcesResponse other = (ListIdentitySourcesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasIdentitySources() == other.hasIdentitySources() && Objects.equals(this.identitySources(), other.identitySources());
    }

    public final String toString() {
        return ToString.builder((String)"ListIdentitySourcesResponse").add("NextToken", (Object)this.nextToken()).add("IdentitySources", this.hasIdentitySources() ? this.identitySources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "IdentitySources": {
                return Optional.ofNullable(clazz.cast(this.identitySources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("IdentitySources", IDENTITY_SOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListIdentitySourcesResponse, T> g) {
        return obj -> g.apply((ListIdentitySourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MpaResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<IdentitySourceForList> identitySources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentitySourcesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.identitySources(model.identitySources);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<IdentitySourceForList.Builder> getIdentitySources() {
            List<IdentitySourceForList.Builder> result = IdentitySourcesCopier.copyToBuilder(this.identitySources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdentitySources(Collection<IdentitySourceForList.BuilderImpl> identitySources) {
            this.identitySources = IdentitySourcesCopier.copyFromBuilder(identitySources);
        }

        @Override
        public final Builder identitySources(Collection<IdentitySourceForList> identitySources) {
            this.identitySources = IdentitySourcesCopier.copy(identitySources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identitySources(IdentitySourceForList ... identitySources) {
            this.identitySources(Arrays.asList(identitySources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identitySources(Consumer<IdentitySourceForList.Builder> ... identitySources) {
            this.identitySources(Stream.of(identitySources).map(c -> (IdentitySourceForList)((IdentitySourceForList.Builder)IdentitySourceForList.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListIdentitySourcesResponse build() {
            return new ListIdentitySourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MpaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIdentitySourcesResponse> {
        public Builder nextToken(String var1);

        public Builder identitySources(Collection<IdentitySourceForList> var1);

        public Builder identitySources(IdentitySourceForList ... var1);

        public Builder identitySources(Consumer<IdentitySourceForList.Builder> ... var1);
    }
}

