/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mpa.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mpa.MpaAsyncClient;
import software.amazon.awssdk.services.mpa.internal.UserAgentUtils;
import software.amazon.awssdk.services.mpa.model.ListResourcePoliciesRequest;
import software.amazon.awssdk.services.mpa.model.ListResourcePoliciesResponse;
import software.amazon.awssdk.services.mpa.model.ListResourcePoliciesResponseResourcePolicy;

public class ListResourcePoliciesPublisher
implements SdkPublisher<ListResourcePoliciesResponse> {
    private final MpaAsyncClient client;
    private final ListResourcePoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResourcePoliciesPublisher(MpaAsyncClient client, ListResourcePoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResourcePoliciesPublisher(MpaAsyncClient client, ListResourcePoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResourcePoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResourcePoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListResourcePoliciesResponseResourcePolicy> resourcePolicies() {
        Function<ListResourcePoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourcePolicies() != null) {
                return response.resourcePolicies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListResourcePoliciesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListResourcePoliciesResponseFetcher
    implements AsyncPageFetcher<ListResourcePoliciesResponse> {
        private ListResourcePoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListResourcePoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResourcePoliciesResponse> nextPage(ListResourcePoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListResourcePoliciesPublisher.this.client.listResourcePolicies(ListResourcePoliciesPublisher.this.firstRequest);
            }
            return ListResourcePoliciesPublisher.this.client.listResourcePolicies((ListResourcePoliciesRequest)((Object)ListResourcePoliciesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

