/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mpa.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mpa.model.MpaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartActiveApprovalTeamDeletionResponse
extends MpaResponse
implements ToCopyableBuilder<Builder, StartActiveApprovalTeamDeletionResponse> {
    private static final SdkField<Instant> DELETION_COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeletionCompletionTime").getter(StartActiveApprovalTeamDeletionResponse.getter(StartActiveApprovalTeamDeletionResponse::deletionCompletionTime)).setter(StartActiveApprovalTeamDeletionResponse.setter(Builder::deletionCompletionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionCompletionTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> DELETION_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeletionStartTime").getter(StartActiveApprovalTeamDeletionResponse.getter(StartActiveApprovalTeamDeletionResponse::deletionStartTime)).setter(StartActiveApprovalTeamDeletionResponse.setter(Builder::deletionStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionStartTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETION_COMPLETION_TIME_FIELD, DELETION_START_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartActiveApprovalTeamDeletionResponse.memberNameToFieldInitializer();
    private final Instant deletionCompletionTime;
    private final Instant deletionStartTime;

    private StartActiveApprovalTeamDeletionResponse(BuilderImpl builder) {
        super(builder);
        this.deletionCompletionTime = builder.deletionCompletionTime;
        this.deletionStartTime = builder.deletionStartTime;
    }

    public final Instant deletionCompletionTime() {
        return this.deletionCompletionTime;
    }

    public final Instant deletionStartTime() {
        return this.deletionStartTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionCompletionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionStartTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartActiveApprovalTeamDeletionResponse)) {
            return false;
        }
        StartActiveApprovalTeamDeletionResponse other = (StartActiveApprovalTeamDeletionResponse)((Object)obj);
        return Objects.equals(this.deletionCompletionTime(), other.deletionCompletionTime()) && Objects.equals(this.deletionStartTime(), other.deletionStartTime());
    }

    public final String toString() {
        return ToString.builder((String)"StartActiveApprovalTeamDeletionResponse").add("DeletionCompletionTime", (Object)this.deletionCompletionTime()).add("DeletionStartTime", (Object)this.deletionStartTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeletionCompletionTime": {
                return Optional.ofNullable(clazz.cast(this.deletionCompletionTime()));
            }
            case "DeletionStartTime": {
                return Optional.ofNullable(clazz.cast(this.deletionStartTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Instant>> map = new HashMap<String, SdkField<Instant>>();
        map.put("DeletionCompletionTime", DELETION_COMPLETION_TIME_FIELD);
        map.put("DeletionStartTime", DELETION_START_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartActiveApprovalTeamDeletionResponse, T> g) {
        return obj -> g.apply((StartActiveApprovalTeamDeletionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MpaResponse.BuilderImpl
    implements Builder {
        private Instant deletionCompletionTime;
        private Instant deletionStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(StartActiveApprovalTeamDeletionResponse model) {
            super(model);
            this.deletionCompletionTime(model.deletionCompletionTime);
            this.deletionStartTime(model.deletionStartTime);
        }

        public final Instant getDeletionCompletionTime() {
            return this.deletionCompletionTime;
        }

        public final void setDeletionCompletionTime(Instant deletionCompletionTime) {
            this.deletionCompletionTime = deletionCompletionTime;
        }

        @Override
        public final Builder deletionCompletionTime(Instant deletionCompletionTime) {
            this.deletionCompletionTime = deletionCompletionTime;
            return this;
        }

        public final Instant getDeletionStartTime() {
            return this.deletionStartTime;
        }

        public final void setDeletionStartTime(Instant deletionStartTime) {
            this.deletionStartTime = deletionStartTime;
        }

        @Override
        public final Builder deletionStartTime(Instant deletionStartTime) {
            this.deletionStartTime = deletionStartTime;
            return this;
        }

        @Override
        public StartActiveApprovalTeamDeletionResponse build() {
            return new StartActiveApprovalTeamDeletionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MpaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartActiveApprovalTeamDeletionResponse> {
        public Builder deletionCompletionTime(Instant var1);

        public Builder deletionStartTime(Instant var1);
    }
}

