/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mpa.endpoints.internal;

import java.util.HashMap;
import java.util.function.Function;
import software.amazon.awssdk.awscore.endpoints.authscheme.EndpointAuthScheme;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4aAuthScheme;
import software.amazon.awssdk.services.mpa.endpoints.internal.DefaultEndpointAuthSchemeStrategy;
import software.amazon.awssdk.services.mpa.endpoints.internal.EndpointAuthSchemeStrategy;
import software.amazon.awssdk.services.mpa.endpoints.internal.EndpointAuthSchemeStrategyFactory;
import software.amazon.awssdk.services.mpa.endpoints.internal.Identifier;
import software.amazon.awssdk.services.mpa.endpoints.internal.Value;

public final class DefaultEndpointAuthSchemeStrategyFactory
implements EndpointAuthSchemeStrategyFactory {
    private static final String SIGV4_NAME = "sigv4";
    private static final String SIGV4A_NAME = "sigv4a";

    @Override
    public EndpointAuthSchemeStrategy endpointAuthSchemeStrategy() {
        HashMap<String, Function<Value.Record, EndpointAuthScheme>> knownAuthSchemesMapping = new HashMap<String, Function<Value.Record, EndpointAuthScheme>>();
        knownAuthSchemesMapping.put(SIGV4A_NAME, this::sigV4A);
        knownAuthSchemesMapping.put(SIGV4_NAME, this::sigV4);
        return new DefaultEndpointAuthSchemeStrategy(knownAuthSchemesMapping);
    }

    private EndpointAuthScheme sigV4A(Value.Record scheme) {
        Value disableDoubleEncoding;
        Value signingRegionSet;
        SigV4aAuthScheme.Builder schemeBuilder = SigV4aAuthScheme.builder();
        Value signingName = scheme.get(Identifier.of("signingName"));
        if (signingName != null) {
            schemeBuilder.signingName(signingName.expectString());
        }
        if ((signingRegionSet = scheme.get(Identifier.of("signingRegionSet"))) != null) {
            Value.Array signingRegionSetArray = signingRegionSet.expectArray();
            for (int j = 0; j < signingRegionSetArray.size(); ++j) {
                schemeBuilder.addSigningRegion(signingRegionSetArray.get(j).expectString());
            }
        }
        if ((disableDoubleEncoding = scheme.get(Identifier.of("disableDoubleEncoding"))) != null) {
            schemeBuilder.disableDoubleEncoding(Boolean.valueOf(disableDoubleEncoding.expectBool()));
        }
        return schemeBuilder.build();
    }

    private EndpointAuthScheme sigV4(Value.Record scheme) {
        Value disableDoubleEncoding;
        Value signingRegion;
        SigV4AuthScheme.Builder schemeBuilder = SigV4AuthScheme.builder();
        Value signingName = scheme.get(Identifier.of("signingName"));
        if (signingName != null) {
            schemeBuilder.signingName(signingName.expectString());
        }
        if ((signingRegion = scheme.get(Identifier.of("signingRegion"))) != null) {
            schemeBuilder.signingRegion(signingRegion.expectString());
        }
        if ((disableDoubleEncoding = scheme.get(Identifier.of("disableDoubleEncoding"))) != null) {
            schemeBuilder.disableDoubleEncoding(Boolean.valueOf(disableDoubleEncoding.expectBool()));
        }
        return schemeBuilder.build();
    }
}

