/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mpa.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mpa.model.IdentitySourceParametersForGet;
import software.amazon.awssdk.services.mpa.model.IdentitySourceStatus;
import software.amazon.awssdk.services.mpa.model.IdentitySourceStatusCode;
import software.amazon.awssdk.services.mpa.model.IdentitySourceType;
import software.amazon.awssdk.services.mpa.model.MpaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIdentitySourceResponse
extends MpaResponse
implements ToCopyableBuilder<Builder, GetIdentitySourceResponse> {
    private static final SdkField<String> IDENTITY_SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentitySourceType").getter(GetIdentitySourceResponse.getter(GetIdentitySourceResponse::identitySourceTypeAsString)).setter(GetIdentitySourceResponse.setter(Builder::identitySourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentitySourceType").build()}).build();
    private static final SdkField<IdentitySourceParametersForGet> IDENTITY_SOURCE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IdentitySourceParameters").getter(GetIdentitySourceResponse.getter(GetIdentitySourceResponse::identitySourceParameters)).setter(GetIdentitySourceResponse.setter(Builder::identitySourceParameters)).constructor(IdentitySourceParametersForGet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentitySourceParameters").build()}).build();
    private static final SdkField<String> IDENTITY_SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentitySourceArn").getter(GetIdentitySourceResponse.getter(GetIdentitySourceResponse::identitySourceArn)).setter(GetIdentitySourceResponse.setter(Builder::identitySourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentitySourceArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(GetIdentitySourceResponse.getter(GetIdentitySourceResponse::creationTime)).setter(GetIdentitySourceResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetIdentitySourceResponse.getter(GetIdentitySourceResponse::statusAsString)).setter(GetIdentitySourceResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusCode").getter(GetIdentitySourceResponse.getter(GetIdentitySourceResponse::statusCodeAsString)).setter(GetIdentitySourceResponse.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(GetIdentitySourceResponse.getter(GetIdentitySourceResponse::statusMessage)).setter(GetIdentitySourceResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_SOURCE_TYPE_FIELD, IDENTITY_SOURCE_PARAMETERS_FIELD, IDENTITY_SOURCE_ARN_FIELD, CREATION_TIME_FIELD, STATUS_FIELD, STATUS_CODE_FIELD, STATUS_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetIdentitySourceResponse.memberNameToFieldInitializer();
    private final String identitySourceType;
    private final IdentitySourceParametersForGet identitySourceParameters;
    private final String identitySourceArn;
    private final Instant creationTime;
    private final String status;
    private final String statusCode;
    private final String statusMessage;

    private GetIdentitySourceResponse(BuilderImpl builder) {
        super(builder);
        this.identitySourceType = builder.identitySourceType;
        this.identitySourceParameters = builder.identitySourceParameters;
        this.identitySourceArn = builder.identitySourceArn;
        this.creationTime = builder.creationTime;
        this.status = builder.status;
        this.statusCode = builder.statusCode;
        this.statusMessage = builder.statusMessage;
    }

    public final IdentitySourceType identitySourceType() {
        return IdentitySourceType.fromValue(this.identitySourceType);
    }

    public final String identitySourceTypeAsString() {
        return this.identitySourceType;
    }

    public final IdentitySourceParametersForGet identitySourceParameters() {
        return this.identitySourceParameters;
    }

    public final String identitySourceArn() {
        return this.identitySourceArn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final IdentitySourceStatus status() {
        return IdentitySourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final IdentitySourceStatusCode statusCode() {
        return IdentitySourceStatusCode.fromValue(this.statusCode);
    }

    public final String statusCodeAsString() {
        return this.statusCode;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identitySourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.identitySourceParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.identitySourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentitySourceResponse)) {
            return false;
        }
        GetIdentitySourceResponse other = (GetIdentitySourceResponse)((Object)obj);
        return Objects.equals(this.identitySourceTypeAsString(), other.identitySourceTypeAsString()) && Objects.equals(this.identitySourceParameters(), other.identitySourceParameters()) && Objects.equals(this.identitySourceArn(), other.identitySourceArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusCodeAsString(), other.statusCodeAsString()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public final String toString() {
        return ToString.builder((String)"GetIdentitySourceResponse").add("IdentitySourceType", (Object)this.identitySourceTypeAsString()).add("IdentitySourceParameters", (Object)this.identitySourceParameters()).add("IdentitySourceArn", (Object)this.identitySourceArn()).add("CreationTime", (Object)this.creationTime()).add("Status", (Object)this.statusAsString()).add("StatusCode", (Object)this.statusCodeAsString()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentitySourceType": {
                return Optional.ofNullable(clazz.cast(this.identitySourceTypeAsString()));
            }
            case "IdentitySourceParameters": {
                return Optional.ofNullable(clazz.cast(this.identitySourceParameters()));
            }
            case "IdentitySourceArn": {
                return Optional.ofNullable(clazz.cast(this.identitySourceArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCodeAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IdentitySourceType", IDENTITY_SOURCE_TYPE_FIELD);
        map.put("IdentitySourceParameters", IDENTITY_SOURCE_PARAMETERS_FIELD);
        map.put("IdentitySourceArn", IDENTITY_SOURCE_ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusCode", STATUS_CODE_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIdentitySourceResponse, T> g) {
        return obj -> g.apply((GetIdentitySourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MpaResponse.BuilderImpl
    implements Builder {
        private String identitySourceType;
        private IdentitySourceParametersForGet identitySourceParameters;
        private String identitySourceArn;
        private Instant creationTime;
        private String status;
        private String statusCode;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentitySourceResponse model) {
            super(model);
            this.identitySourceType(model.identitySourceType);
            this.identitySourceParameters(model.identitySourceParameters);
            this.identitySourceArn(model.identitySourceArn);
            this.creationTime(model.creationTime);
            this.status(model.status);
            this.statusCode(model.statusCode);
            this.statusMessage(model.statusMessage);
        }

        public final String getIdentitySourceType() {
            return this.identitySourceType;
        }

        public final void setIdentitySourceType(String identitySourceType) {
            this.identitySourceType = identitySourceType;
        }

        @Override
        public final Builder identitySourceType(String identitySourceType) {
            this.identitySourceType = identitySourceType;
            return this;
        }

        @Override
        public final Builder identitySourceType(IdentitySourceType identitySourceType) {
            this.identitySourceType(identitySourceType == null ? null : identitySourceType.toString());
            return this;
        }

        public final IdentitySourceParametersForGet.Builder getIdentitySourceParameters() {
            return this.identitySourceParameters != null ? this.identitySourceParameters.toBuilder() : null;
        }

        public final void setIdentitySourceParameters(IdentitySourceParametersForGet.BuilderImpl identitySourceParameters) {
            this.identitySourceParameters = identitySourceParameters != null ? identitySourceParameters.build() : null;
        }

        @Override
        public final Builder identitySourceParameters(IdentitySourceParametersForGet identitySourceParameters) {
            this.identitySourceParameters = identitySourceParameters;
            return this;
        }

        public final String getIdentitySourceArn() {
            return this.identitySourceArn;
        }

        public final void setIdentitySourceArn(String identitySourceArn) {
            this.identitySourceArn = identitySourceArn;
        }

        @Override
        public final Builder identitySourceArn(String identitySourceArn) {
            this.identitySourceArn = identitySourceArn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IdentitySourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusCode() {
            return this.statusCode;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(IdentitySourceStatusCode statusCode) {
            this.statusCode(statusCode == null ? null : statusCode.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public GetIdentitySourceResponse build() {
            return new GetIdentitySourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MpaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIdentitySourceResponse> {
        public Builder identitySourceType(String var1);

        public Builder identitySourceType(IdentitySourceType var1);

        public Builder identitySourceParameters(IdentitySourceParametersForGet var1);

        default public Builder identitySourceParameters(Consumer<IdentitySourceParametersForGet.Builder> identitySourceParameters) {
            return this.identitySourceParameters((IdentitySourceParametersForGet)((IdentitySourceParametersForGet.Builder)IdentitySourceParametersForGet.builder().applyMutation(identitySourceParameters)).build());
        }

        public Builder identitySourceArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder status(String var1);

        public Builder status(IdentitySourceStatus var1);

        public Builder statusCode(String var1);

        public Builder statusCode(IdentitySourceStatusCode var1);

        public Builder statusMessage(String var1);
    }
}

