/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mpa.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details for the resource that provides identities to the identity source. For example, an IAM Identity
 * Center instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentitySourceParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<IdentitySourceParameters.Builder, IdentitySourceParameters> {
    private static final SdkField<IamIdentityCenter> IAM_IDENTITY_CENTER_FIELD = SdkField
            .<IamIdentityCenter> builder(MarshallingType.SDK_POJO).memberName("IamIdentityCenter")
            .getter(getter(IdentitySourceParameters::iamIdentityCenter)).setter(setter(Builder::iamIdentityCenter))
            .constructor(IamIdentityCenter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamIdentityCenter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_IDENTITY_CENTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final IamIdentityCenter iamIdentityCenter;

    private IdentitySourceParameters(BuilderImpl builder) {
        this.iamIdentityCenter = builder.iamIdentityCenter;
    }

    /**
     * <p>
     * IAM Identity Center credentials.
     * </p>
     * 
     * @return IAM Identity Center credentials.
     */
    public final IamIdentityCenter iamIdentityCenter() {
        return iamIdentityCenter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iamIdentityCenter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentitySourceParameters)) {
            return false;
        }
        IdentitySourceParameters other = (IdentitySourceParameters) obj;
        return Objects.equals(iamIdentityCenter(), other.iamIdentityCenter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdentitySourceParameters").add("IamIdentityCenter", iamIdentityCenter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IamIdentityCenter":
            return Optional.ofNullable(clazz.cast(iamIdentityCenter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IamIdentityCenter", IAM_IDENTITY_CENTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdentitySourceParameters, T> g) {
        return obj -> g.apply((IdentitySourceParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdentitySourceParameters> {
        /**
         * <p>
         * IAM Identity Center credentials.
         * </p>
         * 
         * @param iamIdentityCenter
         *        IAM Identity Center credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamIdentityCenter(IamIdentityCenter iamIdentityCenter);

        /**
         * <p>
         * IAM Identity Center credentials.
         * </p>
         * This is a convenience method that creates an instance of the {@link IamIdentityCenter.Builder} avoiding the
         * need to create one manually via {@link IamIdentityCenter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IamIdentityCenter.Builder#build()} is called immediately and its
         * result is passed to {@link #iamIdentityCenter(IamIdentityCenter)}.
         * 
         * @param iamIdentityCenter
         *        a consumer that will call methods on {@link IamIdentityCenter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamIdentityCenter(IamIdentityCenter)
         */
        default Builder iamIdentityCenter(Consumer<IamIdentityCenter.Builder> iamIdentityCenter) {
            return iamIdentityCenter(IamIdentityCenter.builder().applyMutation(iamIdentityCenter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private IamIdentityCenter iamIdentityCenter;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentitySourceParameters model) {
            iamIdentityCenter(model.iamIdentityCenter);
        }

        public final IamIdentityCenter.Builder getIamIdentityCenter() {
            return iamIdentityCenter != null ? iamIdentityCenter.toBuilder() : null;
        }

        public final void setIamIdentityCenter(IamIdentityCenter.BuilderImpl iamIdentityCenter) {
            this.iamIdentityCenter = iamIdentityCenter != null ? iamIdentityCenter.build() : null;
        }

        @Override
        public final Builder iamIdentityCenter(IamIdentityCenter iamIdentityCenter) {
            this.iamIdentityCenter = iamIdentityCenter;
            return this;
        }

        @Override
        public IdentitySourceParameters build() {
            return new IdentitySourceParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
