/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mpa.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details for an approver response in an approval session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSessionResponseApproverResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<GetSessionResponseApproverResponse.Builder, GetSessionResponseApproverResponse> {
    private static final SdkField<String> APPROVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApproverId").getter(getter(GetSessionResponseApproverResponse::approverId))
            .setter(setter(Builder::approverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproverId").build()).build();

    private static final SdkField<String> IDENTITY_SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentitySourceArn").getter(getter(GetSessionResponseApproverResponse::identitySourceArn))
            .setter(setter(Builder::identitySourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentitySourceArn").build()).build();

    private static final SdkField<String> IDENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityId").getter(getter(GetSessionResponseApproverResponse::identityId))
            .setter(setter(Builder::identityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityId").build()).build();

    private static final SdkField<String> RESPONSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Response").getter(getter(GetSessionResponseApproverResponse::responseAsString))
            .setter(setter(Builder::response))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Response").build()).build();

    private static final SdkField<Instant> RESPONSE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ResponseTime")
            .getter(getter(GetSessionResponseApproverResponse::responseTime))
            .setter(setter(Builder::responseTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPROVER_ID_FIELD,
            IDENTITY_SOURCE_ARN_FIELD, IDENTITY_ID_FIELD, RESPONSE_FIELD, RESPONSE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String approverId;

    private final String identitySourceArn;

    private final String identityId;

    private final String response;

    private final Instant responseTime;

    private GetSessionResponseApproverResponse(BuilderImpl builder) {
        this.approverId = builder.approverId;
        this.identitySourceArn = builder.identitySourceArn;
        this.identityId = builder.identityId;
        this.response = builder.response;
        this.responseTime = builder.responseTime;
    }

    /**
     * <p>
     * ID for the approver.
     * </p>
     * 
     * @return ID for the approver.
     */
    public final String approverId() {
        return approverId;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) for the identity source. The identity source manages the user authentication for
     * approvers.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) for the identity source. The identity source manages the user authentication
     *         for approvers.
     */
    public final String identitySourceArn() {
        return identitySourceArn;
    }

    /**
     * <p>
     * ID for the identity source. The identity source manages the user authentication for approvers.
     * </p>
     * 
     * @return ID for the identity source. The identity source manages the user authentication for approvers.
     */
    public final String identityId() {
        return identityId;
    }

    /**
     * <p>
     * Response to the operation request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #response} will
     * return {@link SessionResponse#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #responseAsString}.
     * </p>
     * 
     * @return Response to the operation request.
     * @see SessionResponse
     */
    public final SessionResponse response() {
        return SessionResponse.fromValue(response);
    }

    /**
     * <p>
     * Response to the operation request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #response} will
     * return {@link SessionResponse#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #responseAsString}.
     * </p>
     * 
     * @return Response to the operation request.
     * @see SessionResponse
     */
    public final String responseAsString() {
        return response;
    }

    /**
     * <p>
     * Timestamp when a approver responded to the operation request.
     * </p>
     * 
     * @return Timestamp when a approver responded to the operation request.
     */
    public final Instant responseTime() {
        return responseTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(approverId());
        hashCode = 31 * hashCode + Objects.hashCode(identitySourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(identityId());
        hashCode = 31 * hashCode + Objects.hashCode(responseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(responseTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSessionResponseApproverResponse)) {
            return false;
        }
        GetSessionResponseApproverResponse other = (GetSessionResponseApproverResponse) obj;
        return Objects.equals(approverId(), other.approverId()) && Objects.equals(identitySourceArn(), other.identitySourceArn())
                && Objects.equals(identityId(), other.identityId())
                && Objects.equals(responseAsString(), other.responseAsString())
                && Objects.equals(responseTime(), other.responseTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSessionResponseApproverResponse").add("ApproverId", approverId())
                .add("IdentitySourceArn", identitySourceArn()).add("IdentityId", identityId())
                .add("Response", responseAsString()).add("ResponseTime", responseTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApproverId":
            return Optional.ofNullable(clazz.cast(approverId()));
        case "IdentitySourceArn":
            return Optional.ofNullable(clazz.cast(identitySourceArn()));
        case "IdentityId":
            return Optional.ofNullable(clazz.cast(identityId()));
        case "Response":
            return Optional.ofNullable(clazz.cast(responseAsString()));
        case "ResponseTime":
            return Optional.ofNullable(clazz.cast(responseTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApproverId", APPROVER_ID_FIELD);
        map.put("IdentitySourceArn", IDENTITY_SOURCE_ARN_FIELD);
        map.put("IdentityId", IDENTITY_ID_FIELD);
        map.put("Response", RESPONSE_FIELD);
        map.put("ResponseTime", RESPONSE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSessionResponseApproverResponse, T> g) {
        return obj -> g.apply((GetSessionResponseApproverResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GetSessionResponseApproverResponse> {
        /**
         * <p>
         * ID for the approver.
         * </p>
         * 
         * @param approverId
         *        ID for the approver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approverId(String approverId);

        /**
         * <p>
         * Amazon Resource Name (ARN) for the identity source. The identity source manages the user authentication for
         * approvers.
         * </p>
         * 
         * @param identitySourceArn
         *        Amazon Resource Name (ARN) for the identity source. The identity source manages the user
         *        authentication for approvers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identitySourceArn(String identitySourceArn);

        /**
         * <p>
         * ID for the identity source. The identity source manages the user authentication for approvers.
         * </p>
         * 
         * @param identityId
         *        ID for the identity source. The identity source manages the user authentication for approvers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityId(String identityId);

        /**
         * <p>
         * Response to the operation request.
         * </p>
         * 
         * @param response
         *        Response to the operation request.
         * @see SessionResponse
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionResponse
         */
        Builder response(String response);

        /**
         * <p>
         * Response to the operation request.
         * </p>
         * 
         * @param response
         *        Response to the operation request.
         * @see SessionResponse
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionResponse
         */
        Builder response(SessionResponse response);

        /**
         * <p>
         * Timestamp when a approver responded to the operation request.
         * </p>
         * 
         * @param responseTime
         *        Timestamp when a approver responded to the operation request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseTime(Instant responseTime);
    }

    static final class BuilderImpl implements Builder {
        private String approverId;

        private String identitySourceArn;

        private String identityId;

        private String response;

        private Instant responseTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSessionResponseApproverResponse model) {
            approverId(model.approverId);
            identitySourceArn(model.identitySourceArn);
            identityId(model.identityId);
            response(model.response);
            responseTime(model.responseTime);
        }

        public final String getApproverId() {
            return approverId;
        }

        public final void setApproverId(String approverId) {
            this.approverId = approverId;
        }

        @Override
        public final Builder approverId(String approverId) {
            this.approverId = approverId;
            return this;
        }

        public final String getIdentitySourceArn() {
            return identitySourceArn;
        }

        public final void setIdentitySourceArn(String identitySourceArn) {
            this.identitySourceArn = identitySourceArn;
        }

        @Override
        public final Builder identitySourceArn(String identitySourceArn) {
            this.identitySourceArn = identitySourceArn;
            return this;
        }

        public final String getIdentityId() {
            return identityId;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final String getResponse() {
            return response;
        }

        public final void setResponse(String response) {
            this.response = response;
        }

        @Override
        public final Builder response(String response) {
            this.response = response;
            return this;
        }

        @Override
        public final Builder response(SessionResponse response) {
            this.response(response == null ? null : response.toString());
            return this;
        }

        public final Instant getResponseTime() {
            return responseTime;
        }

        public final void setResponseTime(Instant responseTime) {
            this.responseTime = responseTime;
        }

        @Override
        public final Builder responseTime(Instant responseTime) {
            this.responseTime = responseTime;
            return this;
        }

        @Override
        public GetSessionResponseApproverResponse build() {
            return new GetSessionResponseApproverResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
